package com.mcd.restaurant.repository;

import com.mcd.restaurant.dashboard.enums.HierarchyLevel;
import com.mcd.restaurant.dashboard.utils.StoreDashboardConstants;
import com.mcd.restaurant.model.BreHierarchyNode;
import io.crnk.core.queryspec.*;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class BreHierarchyNodeRepository extends JpaEntityRepositoryBase<BreHierarchyNode, Integer> {


    public static final String MARKET_NODE_ID = "marketNodeId";

    public BreHierarchyNodeRepository() {
        super(BreHierarchyNode.class);
    }

    public QuerySpec prepareQuerySpecFilterForBreHierarchyNodeMarketName(HierarchyLevel hierarchyLevel, String nodeName) {
        QuerySpec querySpec = new QuerySpec(BreHierarchyNode.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.HIERARCHY_LEVEL), FilterOperator.EQ, hierarchyLevel.value());
        FilterSpec filterNameSpec = new FilterSpec(PathSpec.of("nodeName"), FilterOperator.EQ, nodeName);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterSpec, filterNameSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }

    public QuerySpec prepareQuerySpecFilterForBreHierarchyNodeMarketId(HierarchyLevel hierarchyLevel, Integer marketId) {
        QuerySpec querySpec = new QuerySpec(BreHierarchyNode.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.HIERARCHY_LEVEL), FilterOperator.EQ, hierarchyLevel.value());
        FilterSpec filterMarketIdSpec = new FilterSpec(PathSpec.of(MARKET_NODE_ID), FilterOperator.EQ, marketId);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterSpec, filterMarketIdSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }

    public QuerySpec prepareQuerySpecFilterForBreHierarchyNode(HierarchyLevel hierarchyLevel) {
        QuerySpec querySpec = new QuerySpec(BreHierarchyNode.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.HIERARCHY_LEVEL), FilterOperator.EQ, hierarchyLevel.value());
        querySpec.setFilters(Stream.of(filterSpec).collect(Collectors.toList()));
        return querySpec;
    }

    public QuerySpec prepareQuerySpecFilterForBreHierarchyNodeRestaurantNumber(String restaurantNumber, Integer marketId) {
        QuerySpec querySpec = new QuerySpec(BreHierarchyNode.class);
        FilterSpec filterMarketIdSpec = new FilterSpec(PathSpec.of(MARKET_NODE_ID), FilterOperator.EQ, marketId);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.HIERARCHY_LEVEL), FilterOperator.EQ, HierarchyLevel.RESTAURANT.value());
        FilterSpec filterRestaurantNoSpec = new FilterSpec(PathSpec.of("restaurantNo"), FilterOperator.EQ, restaurantNumber);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterSpec, filterRestaurantNoSpec, filterMarketIdSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }

    public QuerySpec prepareQuerySpecFilterForRegionBreHierarchyNodeMarketId(HierarchyLevel hierarchyLevel, Integer marketId, String nodeName) {
        QuerySpec querySpec = new QuerySpec(BreHierarchyNode.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.HIERARCHY_LEVEL), FilterOperator.EQ, hierarchyLevel.value());
        FilterSpec filterMarketIdSpec = new FilterSpec(PathSpec.of(MARKET_NODE_ID), FilterOperator.EQ, marketId);
        FilterSpec filterNodeNameSpec = new FilterSpec(PathSpec.of("nodeName"), FilterOperator.EQ, nodeName);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterSpec, filterMarketIdSpec, filterNodeNameSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }

}
