package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="template", indexes={@Index(name="template_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "template")
public class Template implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable=false)
    private String name;

    @Column(name="is_active", nullable=false)
    private Boolean isActive;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy="template")
    @JsonIgnoreProperties("template")
    @JsonApiRelation(mappedBy = "template")
    @ToString.Exclude
    private List<TemplateApp> templateApps;

    @OneToMany(mappedBy="template")
    @JsonIgnoreProperties("template")
    @JsonApiRelation(mappedBy = "template")
    @ToString.Exclude
    private List<BundleRelease> bundleReleases;
}