package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.*;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "restaurants", indexes = {@Index(name = "restaurants_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "restaurants")
public class Restaurant implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String name;

    @Column(name = "storeStatus")
    private String storeStatus;

    @Column
    private String description;

    @Column
    private String goLiveDate;

    @Column
    private String onboardingDate;

    @CreationTimestamp
    private Timestamp created;

    @Column(name = "no_of_lanes")
    private Integer numberOfLanes;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "restaurant")
    @JsonIgnoreProperties("restaurant")
    @JsonApiRelation(mappedBy = "restaurant")
    @ToString.Exclude
    private List<Component> components;

    @ManyToOne
    @JoinColumn(name = "market_id", nullable = false)
    @JsonIgnoreProperties("restaurants")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Market market;

    @ManyToOne
    @JoinColumn(name = "owner_operator_id")
    @JsonIgnoreProperties("restaurants")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private OwnerOperator ownerOperator;

    @OneToOne
    @JoinColumn(name = "bre_hierarchy_node_id", referencedColumnName = "id")
    @JsonIgnoreProperties("restaurants")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private BreHierarchyNode breHierarchyNode;

    @OneToOne
    @JoinColumn(name = "hierarchy_node_id", referencedColumnName = "id")
    @JsonIgnoreProperties("restaurants")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private HierarchyNode hierarchyNode;


    @OneToMany(mappedBy = "restaurant")
    @JsonIgnoreProperties("restaurant")
    @JsonApiRelation(mappedBy = "restaurant")
    @ToString.Exclude
    private List<HardwareDetail> hardwareDetails;

//    @OneToOne
//    @JoinColumn(name = "hierarchy_node_id", referencedColumnName = "id")
//    @JsonIgnoreProperties("restaurants")
//    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
//    @ToString.Exclude
//    private HierarchyNode hierarchyNode;

    public Restaurant(Integer id, String name) {
        this.id = id;
        this.name = name;
    }
}
