package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.Data;
import lombok.Builder;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.ToString;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Index;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.ManyToOne;
import javax.persistence.JoinColumn;
import javax.persistence.UniqueConstraint;
import javax.persistence.OneToMany;
import javax.persistence.CascadeType;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "product_versions", indexes = {@Index(name = "product_versions_id_IX", columnList = "id", unique = true)}, uniqueConstraints = @UniqueConstraint(columnNames = {
        "versionName", "product_id"}))
@JsonApiResource(type = "product_versions")
public class ProductVersions {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String versionName;

    @Column
    private String isDeployed;

    @ManyToOne
    @JoinColumn(name = "product_id", nullable = false)
    @JsonIgnoreProperties("productVersions")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Products products;

    @OneToMany(mappedBy = "productVersions", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    @JsonIgnoreProperties("productVersions")
    @JsonApiRelation(mappedBy = "productVersions")
    @ToString.Exclude
    private List<ProductApplications> productApplications;

    @OneToMany(mappedBy = "productVersions", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    @JsonIgnoreProperties("productVersions")
    @JsonApiRelation(mappedBy = "productVersions")
    @ToString.Exclude
    private List<DeploymentHistory> deploymentHistory;


    @OneToMany(mappedBy = "productVersions", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    @JsonIgnoreProperties("productVersions")
    @JsonApiRelation(mappedBy = "productVersions")
    @ToString.Exclude
    private List<BundleReleaseAppVersion> bundleReleaseApp;


    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;
}
