package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "deployment_groups", indexes = {
        @Index(name = "deployment_groups_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "deployment_groups")
public class DeploymentGroup {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column
    private String status;

    @Column(name = "deployed_version")
    private String deployedVersion;

    @Column
    private String type;

    @Column
    private String isPostDeploymentTriggered;

    @Column
    private String isPreDeploymentTriggered;

    @Column
    private String isPreCheckFlow;

    @Column
    private String deployedBy;

    @Column
    private Timestamp deploymentTime;

    private Timestamp scheduled;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "deployment_group", cascade = {CascadeType.PERSIST, CascadeType.REMOVE})
    @JsonIgnoreProperties("deployment_group")
    @JsonApiRelation(mappedBy = "deployment_group")
    @ToString.Exclude
    private List<DeploymentHistory> deploymentHistory;

    @ManyToOne
    @JoinColumn(name = "deployment_tag_id", referencedColumnName = "id")
    @JsonIgnoreProperties("deploymentGroups")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private DeploymentTag deploymentTag;

    @ManyToOne
    @JoinColumn(name = "bundle_release_id", referencedColumnName = "id")
    @JsonIgnoreProperties("deploymentGroups")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private BundleRelease bundleRelease;

}
