package com.mcd.restaurant.logging.provider;

import java.io.IOException;
import java.net.InetAddress;

import com.fasterxml.jackson.core.JsonGenerator;

import ch.qos.logback.classic.spi.ILoggingEvent;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.JsonWritingUtils;

public class HostNameProvider extends AbstractFieldJsonProvider<ILoggingEvent> {
	public static final String HOST_NAME = "hostname";
    
    public HostNameProvider() {
        setFieldName(HOST_NAME);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent iLoggingEvent) throws IOException {
        JsonWritingUtils.writeStringField(generator, getFieldName(), InetAddress.getLocalHost().getHostName());
    }
}
