package com.mcd.restaurant.deployment.controller.view.response;

import com.mcd.restaurant.deployment.controller.view.request.DeployRequest;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Data
public class DeployResponse {
    private Integer tagId;
    private String tagName;
    private List<DeployComponentResponse> deploymentIds;
    private Set<Integer> restaurantIds;
    private Timestamp scheduledAt;

    public static DeployResponse build(Integer tagId, String tagName, Integer groupID, DeployRequest request) {
        DeployResponse deployResponse = new DeployResponse();
        deployResponse.setDeploymentIds(request.getDeployComponents().stream().map(it -> DeployComponentResponse.build(it, groupID,request.getDeploymentType())).collect(Collectors.toList()));
        deployResponse.setTagId(tagId);
        deployResponse.setTagName(tagName);
        deployResponse.setRestaurantIds(request.getRestaurantIds());
        deployResponse.setScheduledAt(request.getScheduledAt());
        return deployResponse;
    }
}
