package com.mcd.restaurant.deployment.controller.view.response;

import com.mcd.restaurant.deployment.controller.view.request.DeployComponentRequest;
import com.mcd.restaurant.deployment.service.DeploymentType;
import lombok.Data;


@Data
public class DeployComponentResponse {

    private Integer deploymentId;
    private String deploymentType;
    private String componentName;
    private String vendor;
    private String modelNumber;
    private String updateFromVersion;
    private String updateToVersion;

    public static DeployComponentResponse build(DeployComponentRequest request, Integer id, DeploymentType type) {
        DeployComponentResponse response = new DeployComponentResponse();
        response.deploymentId = id;
        response.deploymentType = type.name();
        response.componentName = request.getComponentName();
        response.vendor = request.getVendor();
        response.modelNumber = request.getModelNumber();
        response.updateFromVersion = request.getUpdateFromVersion();
        response.updateToVersion = request.getUpdateToVersion();
        return response;
    }

}
