package com.mcd.restaurant.deployment.controller.view.request;

import com.mcd.restaurant.deployment.service.DeploymentStatus;
import com.mcd.restaurant.deployment.service.DeploymentType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeployRequest {
    private String tagName;
    private Integer bundleId;
    private Boolean isProductDeployment;
    private Boolean isPreDeploymentCheck;
    private Boolean isBundleDeployment;
    @NotNull
    private DeploymentType deploymentType;
    private List<DeployComponentRequest> deployComponents;
    private Set<Integer> deployProducts;
    private Set<Integer> restaurantIds;
    private Timestamp scheduledAt;
    private DeploymentStatus status;
    private String deployedBy;
    private Integer eventBridgeTime;

    public Optional<String> getTagName() {
        return Optional.ofNullable(tagName);
    }

    public DeploymentStatus getStatus() {
        return status == null && (isPreDeploymentCheck == null || isPreDeploymentCheck == false) ? DeploymentStatus.InProgress : status == null && isPreDeploymentCheck ? DeploymentStatus.STAGED : status;
    }


    public Boolean getIsProductDeployment() {
        return isProductDeployment == null ? false : isProductDeployment;
    }

    public Boolean getIsBundleDeployment() {
        return isBundleDeployment == null ? false : isBundleDeployment;
    }

    public Boolean getIsPreDeploymentCheck() {
        return isPreDeploymentCheck == null ? false : isPreDeploymentCheck;
    }
}
