package com.mcd.restaurant.dashboard.utils.csvhandler;


import com.mcd.restaurant.dashboard.controller.view.request.DemographicStructureBean;
import com.mcd.restaurant.dashboard.controller.view.request.HierarchyStructureBean;
import com.mcd.restaurant.dashboard.controller.view.request.NetworkStructureBean;
import com.mcd.restaurant.dashboard.enums.HierarchyStructure;
import com.mcd.restaurant.dashboard.enums.NetworkStructure;
import com.mcd.restaurant.dashboard.enums.StoreDemographicStructure;
import com.mcd.restaurant.dashboard.error.StoreDashboardException;
import com.mcd.restaurant.dashboard.utils.csvfilter.DemographicNodeTypeFilter;
import com.mcd.restaurant.dashboard.utils.csvfilter.NetworkNodeTypeFilter;
import com.mcd.restaurant.dashboard.utils.csvfilter.NodeTypeFilter;
import com.opencsv.CSVReader;
import com.opencsv.bean.CsvToBean;

import com.opencsv.bean.HeaderColumnNameTranslateMappingStrategy;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.*;

@Component
public class CSVHierarchyHandler {
    public List<HierarchyStructureBean> convertHierarchyCSVToBean(MultipartFile file, String type, String priority) {

        try {
            HeaderColumnNameTranslateMappingStrategy<HierarchyStructureBean> strategy =
                    new HeaderColumnNameTranslateMappingStrategy<>();

            CSVReader csvReader = new CSVReader(new InputStreamReader(file.getInputStream()));
            List<String> headers = fetchAndValidateHeaders(file);

            Map<String, String> mapping = getHierarchyStructureMap(headers);
            strategy.setType(HierarchyStructureBean.class);
            strategy.setColumnMapping(mapping);

            NodeTypeFilter filter = new NodeTypeFilter(strategy, type, priority);

            CsvToBean<HierarchyStructureBean> csvToBean = new CsvToBean<>();
            csvToBean.setFilter(filter);
            csvToBean.setMappingStrategy(strategy);
            csvToBean.setCsvReader(csvReader);
            return csvToBean.parse();
        } catch (Exception e) {
            throw new StoreDashboardException(e.getMessage());
        }

    }

    public List<String> fetchAndValidateHeaders(MultipartFile file) throws IOException {
        CSVReader csvReader;
        Reader reader = new InputStreamReader(file.getInputStream());
        csvReader = new CSVReader(reader);
        List<String> headers = Arrays.asList(csvReader.readNext());
        csvReader.close();
        return headers;
    }


    public List<DemographicStructureBean> convertDemographicCSVToBean(MultipartFile file, String nodeType) throws IOException {
        try {
            HeaderColumnNameTranslateMappingStrategy<DemographicStructureBean> strategy =
                    new HeaderColumnNameTranslateMappingStrategy<>();

            CSVReader csvReader = null;
            List<String> headers = fetchAndValidateHeaders(file);
            csvReader = new CSVReader(new InputStreamReader(file.getInputStream()));
            Map<String, String> mapping = getDemographicHierarchyStructureMap(headers);
            strategy.setType(DemographicStructureBean.class);
            strategy.setColumnMapping(mapping);

            DemographicNodeTypeFilter filter = new DemographicNodeTypeFilter(strategy, nodeType);
            CsvToBean<DemographicStructureBean> csvToBean = new CsvToBean<>();
            csvToBean.setFilter(filter);
            csvToBean.setMappingStrategy(strategy);
            csvToBean.setCsvReader(csvReader);
            return csvToBean.parse();
        } catch (Exception e) {
            throw new StoreDashboardException(e.getMessage());
        }

    }


    public List<NetworkStructureBean> convertNetworkInfoCSVToBean(MultipartFile file) throws IOException {
        try {
            HeaderColumnNameTranslateMappingStrategy<NetworkStructureBean> strategy =
                    new HeaderColumnNameTranslateMappingStrategy<>();

            CSVReader csvReader = null;
            List<String> headers = fetchAndValidateHeaders(file);
            csvReader = new CSVReader(new InputStreamReader(file.getInputStream()));
            Map<String, String> mapping = getNetworkStructureMap(headers);
            strategy.setType(NetworkStructureBean.class);
            strategy.setColumnMapping(mapping);
            NetworkNodeTypeFilter filter = new NetworkNodeTypeFilter(strategy);
            CsvToBean<NetworkStructureBean> csvToBean = new CsvToBean<>();
            csvToBean.setFilter(filter);
            csvToBean.setMappingStrategy(strategy);
            csvToBean.setCsvReader(csvReader);
            return csvToBean.parse();
        } catch (Exception e) {
            throw new StoreDashboardException(e.getMessage());
        }

    }


    public Map<String, String> getNetworkStructureMap(List<String> headers) {
        Map<String, String> mapping = new
                HashMap<>();
        for (int i = 0; i < headers.size(); i++) {
            if (i == 0) {
                if (NetworkStructure.getValueFromKey(headers.get(i)) == null) {
                    mapping.put(headers.get(i), NetworkStructure.getValueFromKey(headers.get(i).substring(1)));
                } else {
                    mapping.put(headers.get(i), NetworkStructure.getValueFromKey(headers.get(i)));
                }
            } else {
                mapping.put(headers.get(i), NetworkStructure.getValueFromKey(headers.get(i)));
            }
        }

        return mapping;
    }

    public Map<String, String> getHierarchyStructureMap(List<String> headers) {
        Map<String, String> mapping = new
                HashMap<>();
        for (int i = 0; i < headers.size(); i++) {
            if (i == 0) {
                if (HierarchyStructure.getValueFromKey(headers.get(i)) == null) {
                    mapping.put(headers.get(i), HierarchyStructure.getValueFromKey(headers.get(i).substring(1)));
                } else {
                    mapping.put(headers.get(i), HierarchyStructure.getValueFromKey(headers.get(i)));
                }
            } else {
                mapping.put(headers.get(i), HierarchyStructure.getValueFromKey(headers.get(i)));
            }
        }

        return mapping;
    }

    public Map<String, String> getDemographicHierarchyStructureMap(List<String> headers) {
        Map<String, String> mapping = new
                HashMap<>();
        for (int i = 0; i < headers.size(); i++) {
            if (i == 0) {
                if (StoreDemographicStructure.getValueFromKey(headers.get(i)) == null) {
                    mapping.put(headers.get(i), StoreDemographicStructure.getValueFromKey(headers.get(i).substring(1)));
                } else {
                    mapping.put(headers.get(i), StoreDemographicStructure.getValueFromKey(headers.get(i)));
                }
            } else {
                mapping.put(headers.get(i), StoreDemographicStructure.getValueFromKey(headers.get(i)));
            }
        }

        return mapping;
    }
}