package com.mcd.restaurant.dashboard.utils.csvfilter;

import com.mcd.restaurant.dashboard.controller.view.request.DemographicStructureBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;


public class DemographicNodeTypeFilter implements CsvToBeanFilter {
    private final MappingStrategy<DemographicStructureBean> strategy;
    private final String nodetype;
    private static final String NODE_TYPE_COLUMN = "NODE TYPE";


    public DemographicNodeTypeFilter(MappingStrategy<DemographicStructureBean> strategy, String nodetype) {
        this.strategy = strategy;
        this.nodetype = nodetype;
    }

    @Override
    public boolean allowLine(String[] strings) {
        List<String> headers = Stream.of(strategy.generateHeader()).collect(Collectors.toList());
        int nodeTypeIndex = headers.indexOf(NODE_TYPE_COLUMN);
        if (nodeTypeIndex == -1 && NODE_TYPE_COLUMN.equals(headers.get(0).substring(1))) {
            nodeTypeIndex = 0;
        }
        String nodeTypValue = strings[nodeTypeIndex];
        return nodetype.equalsIgnoreCase(nodeTypValue);

    }


}
