package com.mcd.restaurant.dashboard.enums;

public enum HierarchyStructure {
    NODE_TYPE("Node Type", "nodeType"), RESTAURANT_NUMBER("Restaurant Number", "restaurantNumber"), NODE_NAME("Node Name", "nodeName"), PARENT_NODE_NAME("Parent Node Name", "parentNodeName"), PRIORITY
            ("Priority","priority");


    private final String key;
    private final String value;

    HierarchyStructure(String k, String v) {
        key = k;
        value = v;
    }

    public String getValue() {
        return value;
    }

    public String getKey() {
        return key;
    }

    public static String getValueFromKey(String key) {
        for (HierarchyStructure structure : HierarchyStructure.values()) {
            if (structure.getKey().equals(key)) {
                return structure.getValue();
            }
        }
        return null;
    }
}
