package com.mcd.restaurant.component.service;

import com.mcd.restaurant.common.Constants;
import com.mcd.restaurant.component.controller.view.request.DeviceDetailRequestDTO;
import com.mcd.restaurant.component.controller.view.response.DeviceDetailResponseDTO;
import com.mcd.restaurant.component.error.ComponentBadRequestException;
import com.mcd.restaurant.deployment.service.DeploymentUtils;
import com.mcd.restaurant.model.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.List;

@Service
@Slf4j
public class ComponentService {

    @Autowired
    DeploymentUtils deploymentUtils;

    @Autowired
    ComponentUtils componentUtils;

    @Transactional
    public DeviceDetailResponseDTO deviceDetails(List<DeviceDetailRequestDTO> deviceDetailRequest)
    {
        try {
            if(CollectionUtils.isEmpty(deviceDetailRequest))
            {
                throw new ComponentBadRequestException(Constants.DEVICE_DETAILS_ARE_REQUIRED_FOR_THIS_OPERATION);
            }
            deviceDetailRequest.forEach(device -> {

                if(CollectionUtils.isEmpty(device.getDeviceProps()))
                {
                    throw new ComponentBadRequestException(Constants.DEVICE_PROP_DETAILS_ARE_REQUIRED_SUCH_AS_LANE_NUMBER_IP_ADDRESS_MAC_ADDRESS);
                }
            });

            DeviceDetailResponseDTO response = new DeviceDetailResponseDTO();

            //validate request
            componentUtils.validateRequest(deviceDetailRequest);

            //validate market name and their restaurants
            List<Restaurant> restaurantDetails = componentUtils.validateMarketsWithRestaurants(deviceDetailRequest);

            //get already existed restaurants
            List<Component> alreadyExistedRestroDevices = componentUtils.getAlreadyExistedRestroDevices(deviceDetailRequest);

            //validate if DEVICE is present in component type table
            ComponentType type = deploymentUtils.fetchComponentType("DEVICE");

            //validate if Axis present in vendor table
            Vendor vendor = componentUtils.fetchVendorKey("Axis");

            //insert data in component and componentProm table
            response.setComponent(componentUtils.insertDeviceData(deviceDetailRequest,restaurantDetails,type,vendor,alreadyExistedRestroDevices));
            return response;
        }
        catch (ComponentBadRequestException ex)
        {
            throw ex;
        }
        catch (Exception e)
        {
            throw new ComponentBadRequestException(e.getMessage());
        }
    }

}
