package com.mcd.restaurant.bundledrelease.controller.view.request;

import com.mcd.restaurant.model.HierarchyNode;
import com.mcd.restaurant.model.Market;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.Data;
import lombok.Generated;
import lombok.Builder;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import javax.persistence.Column;
import javax.persistence.Id;
import java.sql.Timestamp;

@Data
@Generated
@Builder
@JsonApiResource(type = "restaurant_report", postable = false, patchable = false, deletable = false,
        sortable = false
)
@NoArgsConstructor
@AllArgsConstructor
public class DeployBundleReleaseAppCheckDTO {
    @Id
    @JsonApiId
    private int id;

    @Column
    private int bundleId;

    @Column(nullable = false)
    private String name;

    @Column
    private String description;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    private Market market;

    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    private HierarchyNode hierarchyNode;
}
