package com.mcd.restaurant.bundledrelease.controller.view.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mcd.restaurant.bundledrelease.enums.BundledReleaseStatus;
import lombok.Data;
import java.util.List;


@Data
public class BundledReleaseRequest {

    @JsonProperty(value = "id")
    private int id;
    @JsonProperty(value = "releaseName", required = true)
    private String releaseName;
    @JsonProperty(value = "templateId")
    private Integer templateId;
    @JsonProperty(value = "createdBy", required = true)
    private String createdBy;
    @JsonProperty(value = "updatedBy", required = true)
    private String updatedBy;
    @JsonProperty("apps")
    private List<BundledAppVersionRequest> bundledAppVersionRequestList;
    @JsonProperty("products")
    private List<Integer> productVersionIdList;
    @JsonProperty(value = "status")
    private BundledReleaseStatus status;


    public BundledReleaseStatus getStatus() {
        return status == null ? BundledReleaseStatus.STAGED : status;
    }
}
