package com.mcd.restaurant.deployment.testUtils;

import com.mcd.restaurant.deployment.service.DeploymentStatus;
import com.mcd.restaurant.model.DeploymentGroup;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class DeploymentTestUtility {

    public ResourceList<DeploymentGroup> getDeploymentGroupList(Long created) {
        LocalDateTime createdDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneId.of("UTC"));
        createdDate.plusHours(1);
        DeploymentGroup group = new DeploymentGroup();
        group.setId(new Random().nextInt());
        group.setCreated(new Timestamp(createdDate.toEpochSecond(ZoneOffset.UTC) * 1000));
        DefaultResourceList<DeploymentGroup> deploymentGroupResourceList = new DefaultResourceList<>();
        deploymentGroupResourceList.add(group);
        return deploymentGroupResourceList;
    }

    public QuerySpec prepareQuerySpecFilterForGraph(String status, Long startTime, Long endTime) {
        QuerySpec querySpec = new QuerySpec(DeploymentGroup.class);
        FilterSpec filterExtremeDate = new FilterSpec(PathSpec.of("created"), FilterOperator.LT, new Timestamp(endTime));
        FilterSpec filterMinimumDate = new FilterSpec(PathSpec.of("created"), FilterOperator.GE, new Timestamp(startTime));
        FilterSpec filterStatus = new FilterSpec(PathSpec.of("deploymentHistory.status"), FilterOperator.EQ, status);
        FilterSpec finalFilter = FilterSpec.and(Stream.of(filterStatus, filterExtremeDate, filterMinimumDate).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(finalFilter).collect(Collectors.toList()));

        return querySpec;
    }
}

