//package com.mcd.restaurant;
//
//import io.restassured.RestAssured;
//import io.restassured.builder.RequestSpecBuilder;
//import io.restassured.specification.RequestSpecification;
//import org.json.JSONException;
//import org.json.JSONObject;
//import org.junit.jupiter.api.BeforeEach;
//import org.junit.jupiter.api.Test;
//import org.junit.jupiter.api.extension.ExtendWith;
//import org.junit.jupiter.params.ParameterizedTest;
//import org.junit.jupiter.params.provider.CsvSource;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.boot.web.server.LocalServerPort;
//import org.springframework.restdocs.RestDocumentationContextProvider;
//import org.springframework.restdocs.RestDocumentationExtension;
//import org.springframework.restdocs.operation.preprocess.Preprocessors;
//import org.springframework.restdocs.payload.PayloadDocumentation;
//import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
//import org.springframework.test.context.ActiveProfiles;
//import org.springframework.test.context.junit.jupiter.SpringExtension;
//
//import java.util.Arrays;
//
//import static org.hamcrest.CoreMatchers.*;
//
//@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
//@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
//@ActiveProfiles("test")
//class RestaurantAssetsApplicationTests {
//
//    private RequestSpecification spec;
//
//    @LocalServerPort
//    int port;
//
//    @BeforeEach
//    public void setUp(RestDocumentationContextProvider restDocumentation) {
//        RestAssured.port = port;
//
//        this.spec = new RequestSpecBuilder()
//                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
//                        .withResponseDefaults(Preprocessors.prettyPrint()))
//                .build();
//    }
//
//    // Component
//    @Test
//    void getComponent() {
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getComponent"))
//                .when().get("/restaurant_assets/components")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void getComponentById() {
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getComponentById"))
//                .when().get("/restaurant_assets/components/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponent() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"components\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Component_Name_New\",\n" +
//                "            \"serialNumber\": 344209859,\n" +
//                "            \"reportedVersion\": \"1.1\",\n" +
//                "            \"installDate\": \"2019-08-20T01:14:14\",\n" +
//                "            \"parentComponent\": 0,\n" +
//                "            \"warranty\": \"2019-07-10T01:14:04\",\n" +
//                "            \"modelNumber\": 123\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"restaurant\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"restaurants\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"type\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"component_type\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"vendor\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"vendors\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponent", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/components")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponent() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"components\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Component_Name_Changed\",\n" +
//                "            \"serialNumber\": 344209859,\n" +
//                "            \"reportedVersion\": \"1.2\",\n" +
//                "            \"installDate\": \"2019-08-20T01:14:14\",\n" +
//                "            \"parentComponent\": 0,\n" +
//                "            \"warranty\": \"2019-07-10T01:14:04\",\n" +
//                "            \"modelNumber\": 123\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"restaurant\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"restaurants\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"type\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"component_type\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"vendor\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"vendors\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponent", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/components/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponent() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponent"))
//                .when().delete("/restaurant_assets/components/0")
//                .then().assertThat().statusCode(is(204));
//    }
//
//    // Restaurant
//    @Test
//    void getRestaurant() {
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getRestaurant"))
//                .when().get("/restaurant_assets/restaurants")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void getRestaurantByComponentNameAndReportedVersion() {
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getRestaurantByComponentNameAndReportedVersion"))
//                .when().get("/restaurant_assets/restaurants?include=components&filter[restaurants][components.name]=TestComponent&filter[restaurants][components.reportedVersion]=1.0.3&fields=id,name")
//                .then().assertThat().statusCode(is(200))
//                .body("data.size()", equalTo(2))
//                .body("included.size()", equalTo(5));
//    }
//
//    @Test
//    void getRestaurantById() {
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getRestaurantById"))
//                .when().get("/restaurant_assets/restaurants/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @ParameterizedTest
//    @CsvSource({"Restaurant_Name_NewW,201,1", "101,400,1","177,201,1","199,400,2"})
//    void postRestaurant(String name,Integer status,String marketId) {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"restaurants\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"%s\",\n" +
//                "            \"description\": \"Restaurant_Description\"\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"market\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"%s\",\n" +
//                "                    \"type\": \"markets\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"ownerOperator\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"owner_operators\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//        jsonBody = String.format(jsonBody, name,marketId);
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postRestaurant", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/restaurants")
//                .then().assertThat().statusCode(is(status));
//    }
//
//
//    @Test
//    void postRestaurantWithBreHierarchyNode() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"restaurants\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"abc\",\n" +
//                "            \"description\": \"Restaurant_Description\"\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"market\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"markets\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"breHierarchyNode\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"2\",\n" +
//                "                    \"type\": \"bre_hierarchy_nodes\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postRestaurant", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/restaurants")
//                .then().assertThat().statusCode(is(201));
//    }
//
//
//    @Test
//    void patchRestaurant() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"restaurants\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Restaurant_Name_Changed\",\n" +
//                "            \"description\": \"Restaurant_Description_Changed\"\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"market\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"markets\"\n" +
//                "                }\n" +
//                "            },\n" +
//                "            \"ownerOperator\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"owner_operators\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchRestaurant", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/restaurants/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteRestaurantDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteRestaurant"))
//                .when().delete("/restaurant_assets/restaurants/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // ComponentAuditHistory
//    @Test
//    void getListOfComponentAuditHistory() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getComponentAuditHistory"))
//                .when().get("/restaurant_assets/component_audit_history")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponentAuditHistory() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_audit_history\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"action\": \"action\",\n" +
//                "            \"srcOfAction\": \"source of action\",\n" +
//                "            \"description\": \"description\"\n" +
//                "        },\n" +
//                "        \"relationships\": {\n" +
//                "            \"component\": {\n" +
//                "                \"data\": {\n" +
//                "                    \"id\": \"1\",\n" +
//                "                    \"type\": \"components\"\n" +
//                "                }\n" +
//                "            }\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponentAuditHistory", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/component_audit_history")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponentAuditHistory() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_audit_history\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"description\": \"Component_audit_history_description_Changed\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponentAuditHistory", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/component_audit_history/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponentAuditHistoryDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponentAuditHistory"))
//                .when().delete("/restaurant_assets/component_audit_history/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // ComponentGroup
//    @Test
//    void getListOfComponentGroup() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getComponentGroup"))
//                .when().get("/restaurant_assets/component_groups")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponentGroup() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_groups\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"component_group_name_new\",\n" +
//                "            \"type\": \"component_group_type_new\",\n" +
//                "            \"version\": 1\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponentGroup", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/component_groups")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponentGroup() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_groups\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"component_group_name_changed\",\n" +
//                "            \"type\": \"component_group_type_changed\",\n" +
//                "            \"version\": 2\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponentGroup", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/component_groups/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponentGroupDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponentGroup"))
//                .when().delete("/restaurant_assets/component_groups/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // ComponentPropertiesType
//    @Test
//    void getListOfComponentPropertiesType() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getComponentPropertiesType"))
//                .when().get("/restaurant_assets/component_properties_type")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponentPropertiesType() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_properties_type\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Component_Properties_Type_Name_New\",\n" +
//                "            \"description\": \"Component_Properties_Type_Description_New\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponentPropertiesType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/component_properties_type")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponentPropertiesType() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_properties_type\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"description\": \"Component_Properties_Type_Description_Changed\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponentPropertiesType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/component_properties_type/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponentPropertiesTypeDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponentPropertiesType"))
//                .when().delete("/restaurant_assets/component_properties_type/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // ComponentProp
//    @Test
//    void getListOfComponentProp() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getComponentProp"))
//                .when().get("/restaurant_assets/component_props")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponentProp() {
//        String jsonBody = "{\"data\": \n" +
//                "        {\n" +
//                "        	\n" +
//                "            \"type\": \"component_props\",\n" +
//                "            \"attributes\": {\n" +
//                "		        \"propertyName\": \"Component_Prop_Name_New\",\n" +
//                "		        \"propertyValue\": \"Component_Prop_Value_New\"\n" +
//                "            },\n" +
//                "	            \"relationships\": {\n" +
//                "		            \"type\": {\n" +
//                "				    	\"data\":	{\n" +
//                "				            \"type\": \"component_properties_type\",\n" +
//                "				            \"id\": 1\n" +
//                "		            	}\n" +
//                "		            },\n" +
//                "		            \"component\": {\n" +
//                "				    	\"data\":	{\n" +
//                "				            \"type\": \"components\",\n" +
//                "				            \"id\": 1\n" +
//                "		            	}\n" +
//                "		            }\n" +
//                "	            }\n" +
//                "	}\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponentProp", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/component_props")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponentProp() {
//        String jsonBody = "{\"data\": \n" +
//                "        {\n" +
//                "        	\n" +
//                "            \"type\": \"component_props\",\n" +
//                "            \"attributes\": {\n" +
//                "		        \"propertyName\": \"Component_Prop_Name_Changed\",\n" +
//                "		        \"propertyValue\": \"Component_Prop_Value_Changed\"\n" +
//                "            },\n" +
//                "	            \"relationships\": {\n" +
//                "		            \"type\": {\n" +
//                "				    	\"data\":	{\n" +
//                "				            \"type\": \"component_properties_type\",\n" +
//                "				            \"id\": 1\n" +
//                "		            	}\n" +
//                "		            },\n" +
//                "		            \"component\": {\n" +
//                "				    	\"data\":	{\n" +
//                "				            \"type\": \"components\",\n" +
//                "				            \"id\": 1\n" +
//                "		            	}\n" +
//                "		            }\n" +
//                "	            }\n" +
//                "	}\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponentProp", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/component_props/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponentPropDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponentProp"))
//                .when().delete("/restaurant_assets/component_props/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // ComponentType
//    @Test
//    void getListOfComponentType() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getComponentType"))
//                .when().get("/restaurant_assets/component_type")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postComponentType() {
//        String jsonBody = "{\"data\": \n" +
//                "	        {\n" +
//                "	            \"type\": \"component_type\",\n" +
//                "	            \"attributes\": {\n" +
//                "                \"name\": \"Component_Type_Name_New\",\n" +
//                "                \"description\": \"Component_Type_Description_New\"\n" +
//                "        		}\n" +
//                "	        }\n" +
//                "	}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postComponentType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/component_type")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchComponentType() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"component_type\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"description\": \"Component_Type_Description_Changed\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchComponentType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/component_type/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteComponentTypeDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteComponentType"))
//                .when().delete("/restaurant_assets/component_type/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // Market
//    @Test
//    void getListOfMarket() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getMarket"))
//                .when().get("/restaurant_assets/markets")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postMarket() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"markets\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Market_Name_New\",\n" +
//                "            \"type\": \"Market_Type_New\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postMarket", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/markets")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchMarket() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"markets\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"type\": \"Market_Type_Changed\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchMarket", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/markets/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteMarketDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteMarket"))
//                .when().delete("/restaurant_assets/markets/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // OwnerOperator
//    @Test
//    void getListOfOwnerOperator() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getOwnerOperator"))
//                .when().get("/restaurant_assets/owner_operators")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postOwnerOperator() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"owner_operators\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Name_New\",\n" +
//                "            \"onsiteSupportEngineer\": \"Onsite_Support_Engineer_New\",\n" +
//                "            \"preferences\": \"Preferences_New\",\n" +
//                "            \"contactInfo\": \"123-456-789\",\n" +
//                "            \"breSubscription\": \"Bre_Subscription_New\",\n" +
//                "            \"contactInfoType\": \"phone\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postOwnerOperator", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/owner_operators")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchOwnerOperator() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"owner_operators\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Name_Changed\",\n" +
//                "            \"onsiteSupportEngineer\": \"Onsite_Support_Engineer_Changed\",\n" +
//                "            \"preferences\": \"Preferences_Changed\",\n" +
//                "            \"contactInfo\": \"123-456-789\",\n" +
//                "            \"breSubscription\": \"Bre_Subscription_Changed\",\n" +
//                "            \"contactInfoType\": \"phone\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchOwnerOperator", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/owner_operators/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteOwnerOperatorDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteOwnerOperator"))
//                .when().delete("/restaurant_assets/owner_operators/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // VendorType
//    @Test
//    void getListOfVendorType() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getVendorType"))
//                .when().get("/restaurant_assets/vendor_type")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postVendorType() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"vendor_type\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Vendor_Type_Name_New\",\n" +
//                "            \"description\": \"Vendor_Type_Description_New\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postVendorType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/vendor_type")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchVendorType() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"vendor_type\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"description\": \"Vendor_Type_Description_Changed\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchVendorType", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/vendor_type/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteVendorTypeDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteVendorType"))
//                .when().delete("/restaurant_assets/vendor_type/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // Vendor
//    @Test
//    void getListOfVendor() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("getVendor"))
//                .when().get("/restaurant_assets/vendors")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postVendor() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"vendors\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Vendor_Name_1\",\n" +
//                "            \"notes\": \"zzzzzzz\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postVendor", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().post("/restaurant_assets/vendors")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void patchVendor() {
//        String jsonBody = "{\n" +
//                "    \"data\": {\n" +
//                "        \"type\": \"vendors\",\n" +
//                "        \"attributes\": {\n" +
//                "            \"name\": \"Vendor_Name_1\",\n" +
//                "            \"notes\": \"zzzzzzz\"\n" +
//                "        }\n" +
//                "    }\n" +
//                "}";
//
//        RestAssured.given(this.spec)
//                .contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchVendor", PayloadDocumentation.relaxedRequestFields(
//                        PayloadDocumentation.subsectionWithPath("data").description("the top-level request field"))))
//                .body(jsonBody)
//                .when().patch("/restaurant_assets/vendors/1")
//                .then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void deleteVendorDisabled() {
//        RestAssured.given(this.spec)
//                .accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteVendor"))
//                .when().delete("/restaurant_assets/vendors/0")
//                .then().assertThat().statusCode(is(403));
//    }
//
//    // Deployment
//    @Test
//    void getDeploymentList() {
//        RestAssured.given(this.spec).accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getDeployment_group")).when()
//                .get("/restaurant_assets/deployment_groups").then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postDeploymentGroup() throws JSONException {
//        JSONObject body = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("deployedVersion", "0.0.3");
//        attributeJSON.put("type", "docker");
//        // fill data JSON
//        dataJSON.put("type", "deployment_groups");
//        dataJSON.put("attributes", attributeJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postDeploymentGroup",
//                        PayloadDocumentation.relaxedRequestFields(PayloadDocumentation.subsectionWithPath("data")
//                                .description("the top-level request field"))))
//                .body(body.toString()).when().post("/restaurant_assets/deployment_groups").then().assertThat()
//                .statusCode(is(201));
//    }
//
//    @Test
//    void patchDeployment() throws JSONException {
//        JSONObject body = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("deployedVersion", "0.0.3");
//        attributeJSON.put("type", "docker");
//        // fill data JSON
//        dataJSON.put("type", "deployment_groups");
//        dataJSON.put("attributes", attributeJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchDeploymentGroup",
//                        PayloadDocumentation.relaxedRequestFields(PayloadDocumentation.subsectionWithPath("data")
//                                .description("the top-level request field"))))
//                .body(body.toString()).when().patch("/restaurant_assets/deployment_groups/1").then().assertThat()
//                .statusCode(is(200));
//    }
//
//    @Test
//    void deleteDeployment() {
//        RestAssured.given(this.spec).accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteDeploymentGroup")).when()
//                .delete("/restaurant_assets/deployment_groups/2").then().assertThat().statusCode(is(204));
//    }
//
//    // Deployment History
//    @Test
//    void getDeploymentHistory() {
//        RestAssured.given(this.spec).accept("application/json")
//                .filter(RestAssuredRestDocumentation.document("getDeploymentHistory")).when()
//                .get("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(200));
//    }
//
//    @Test
//    void postDeploymentHistory() throws JSONException {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "2");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//        RestAssured.given(this.spec).contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("postDeploymentHistory",
//                        PayloadDocumentation.relaxedRequestFields(PayloadDocumentation.subsectionWithPath("data")
//                                .description("the top-level request field"))))
//                .body(body.toString()).when().post("/restaurant_assets/deployment_history").then().assertThat()
//                .statusCode(is(201));
//    }
//
//    @Test
//    void patchDeploymentHistory() throws JSONException {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "Completed");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//        RestAssured.given(this.spec).contentType("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("patchDeploymentHistory",
//                        PayloadDocumentation.relaxedRequestFields(PayloadDocumentation.subsectionWithPath("data")
//                                .description("the top-level request field"))))
//                .body(body.toString()).when().patch("/restaurant_assets/deployment_history/1").then().assertThat()
//                .statusCode(is(200));
//    }
//
//    @Test
//    void deleteDeploymentHistoryDisabled() {
//        RestAssured.given(this.spec).accept("application/vnd.api+json")
//                .filter(RestAssuredRestDocumentation.document("deleteDeploymentHistory")).when()
//                .delete("/restaurant_assets/deployment_history/2").then().assertThat().statusCode(is(403));
//    }
//
//}
