package com.mcd.restaurant;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import net.minidev.json.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
 class DeviceTests {

    private RequestSpecification spec;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
     void getDeviceWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/device/123")
                .then().assertThat().statusCode(is(404));
    }

    @Test
     void getDeviceWhenIDIsNull() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/device/null")
                .then().assertThat().statusCode(is(500));
    }

    @Test
     void getDeviceWhenIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/device/").then()
                .statusCode(is(200));
    }

    @Test
     void postDeviceWhenInputJSONIsEmpty() {
        String jsonBody = "";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/device").then().assertThat().statusCode(is(400));
    }

    @Test
     void postDeviceWhenInputJSONIsInvalid() {
        String jsonBody = "{}";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/device").then().assertThat().statusCode(is(400));
    }

    @Test
     void postDeviceWhenInputJSONIsValid() {
        JSONObject body = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        JSONObject subDataJSON = new JSONObject();
        JSONObject outerDataJSON = new JSONObject();
        JSONObject vendorJSON = new JSONObject();
        attributeJSON.put("name", "camera4");
        attributeJSON.put("deviceFlag", true);
       attributeJSON.put("abbreviation", "CAM");
        subDataJSON.put("type", "vendors");
        subDataJSON.put("id", 1);
        outerDataJSON.put("data", subDataJSON);
        vendorJSON.put("vendor", outerDataJSON);
        // fill data JSON
        dataJSON.put("type", "device");
        dataJSON.put("attributes", attributeJSON);
        dataJSON.put("relationships", vendorJSON);
        body.put("data", dataJSON);
        System.out.println(body.toString());
        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/device").then().assertThat().statusCode(is(201));
    }
}