//package com.mcd.restaurant;
//
//import io.restassured.RestAssured;
//import io.restassured.builder.RequestSpecBuilder;
//import io.restassured.specification.RequestSpecification;
//import net.minidev.json.JSONObject;
//import org.junit.jupiter.api.BeforeEach;
//import org.junit.jupiter.api.Test;
//import org.junit.jupiter.api.extension.ExtendWith;
//import org.junit.jupiter.params.ParameterizedTest;
//import org.junit.jupiter.params.provider.CsvSource;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.boot.web.server.LocalServerPort;
//import org.springframework.restdocs.RestDocumentationContextProvider;
//import org.springframework.restdocs.RestDocumentationExtension;
//import org.springframework.restdocs.operation.preprocess.Preprocessors;
//import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
//import org.springframework.test.context.ActiveProfiles;
//import org.springframework.test.context.junit.jupiter.SpringExtension;
//
//import static org.hamcrest.CoreMatchers.is;
//
//@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
//@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
//@ActiveProfiles("test")
//class DeploymentHistoryTests {
//
//    private RequestSpecification spec;
//
//    @LocalServerPort
//    int port;
//
//    @BeforeEach
//    public void setUp(RestDocumentationContextProvider restDocumentation) {
//        RestAssured.port = port;
//
//        this.spec = new RequestSpecBuilder()
//                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
//                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
//                .build();
//    }
//
//    @Test
//    void getHistoryWhenIDIsInvalid() {
//        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deployment_history/123")
//                .then().assertThat().statusCode(is(404));
//    }
//
//    @Test
//    void getHistoryWhenIDIsNull() {
//        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deployment_history/null")
//                .then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void getHistoryWhenIDIsMissing() {
//        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deployment_history/")
//                .then().statusCode(is(200));
//    }
//
//    @Test
//    void postHistoryWhenInputJSONIsEmpty() {
//        String jsonBody = "";
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(400));
//    }
//
//    @Test
//    void postHistoryWhenInputJSONIsInvalid() {
//        String jsonBody = "{}";
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(400));
//    }
//
//    @Test
//    void postHistoryWhenInputJSONIsInvalidDataKeyMissing() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data2", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(400));
//    }
//
//    @Test
//    void postHistoryWhenComponentIdIsMissing() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenComponentIdIsEmpty() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenComponentIdIsNull() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", null);
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenComponentIdIsInvalid() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "abdgh");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenRestIDIsMissing() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenGroupIDIsMissing() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenGroupIdIsEmpty() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    void postHistoryWhenGroupIdIsNull() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", null);
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", null);
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenGroupIdIsInvalid() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1sss");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "abcdef");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenRestaurantIdIsEmpty() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    void postHistoryWhenRestaurantIdIsNull() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "2");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", null);
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenVendorIdIsInvalid() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "abcdef");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenRestaurantAndComponentIDAreInvalid() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1sd");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1rtyty");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenRestaurantAndComponentIdAreEmpty() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void postHistoryWhenRestaurantAndComponentIdAreMissing() {
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .post("/restaurant_assets/deployment_history").then().assertThat().statusCode(is(500));
//    }
//
//    @ParameterizedTest
//    @CsvSource({"12,404", "abc,500", "null,500", ",500"})
//    void patchHistoryWhenComponentIdIsDoesNotExists(String id, int code) {
//
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .patch("/restaurant_assets/deployment_history/10").then().assertThat().statusCode(is(404));
//    }
//
//
//    @Test
//    void patchHistoryWhenComponentIdIsMising() {
//
//        JSONObject body = new JSONObject();
//        JSONObject relationShipJSON = new JSONObject();
//        JSONObject dataJSON = new JSONObject();
//        JSONObject componentJSON = new JSONObject();
//        JSONObject deploymentJSON = new JSONObject();
//        JSONObject restJSON = new JSONObject();
//        JSONObject restDataJSON = new JSONObject();
//        JSONObject componentDataJSON = new JSONObject();
//        JSONObject deploymentDataJSON = new JSONObject();
//        JSONObject attributeJSON = new JSONObject();
//        attributeJSON.put("status", "In-Progress");
//        // fill data JSON
//        dataJSON.put("type", "deployment_history");
//        dataJSON.put("attributes", attributeJSON);
//        // fill market and owner operator json
//        componentDataJSON.put("type", "components");
//        componentDataJSON.put("id", "1");
//        deploymentDataJSON.put("id", "1");
//        deploymentDataJSON.put("type", "deployment_groups");
//        restDataJSON.put("id", "1");
//        restDataJSON.put("type", "restaurants");
//
//        deploymentJSON.put("data", deploymentDataJSON);
//        componentJSON.put("data", componentDataJSON);
//        restJSON.put("data", restDataJSON);
//        relationShipJSON.put("deployment_group", deploymentJSON);
//        relationShipJSON.put("component", componentJSON);
//        relationShipJSON.put("restaurant", restJSON);
//
//        dataJSON.put("relationships", relationShipJSON);
//        body.put("data", dataJSON);
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
//                .patch("/restaurant_assets/deployment_history/").then().assertThat().statusCode(is(400));
//    }
//
//
//    @Test
//    void patchHistoryWhenInputJSONIsEmptyString() {
//        String body = "";
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body).when()
//                .patch("/restaurant_assets/deployment_history/null").then().assertThat().statusCode(is(500));
//    }
//
//    @Test
//    void patchHistoryWhenInputJSONIsEmptyAndComponentIdIsInvalid() {
//        String body = "";
//
//        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body).when()
//                .patch("/restaurant_assets/deployment_history/abc").then().assertThat().statusCode(is(500));
//    }
//}
