package com.mcd.restaurant.repository;

import com.mcd.restaurant.dashboard.utils.StoreDashboardConstants;
import com.mcd.restaurant.model.StoreDataJob;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

@Component
public class StoreDataJobRepository extends JpaEntityRepositoryBase<StoreDataJob, Integer> {
    public StoreDataJobRepository() {
        super(StoreDataJob.class);
    }

    public Integer saveJobWithNativeQuery(StoreDataJob storeDataJob) {
        return this.getEntityManager().createNativeQuery(String.format(StoreDashboardConstants.STORE_QUERY, storeDataJob.getStatus(), storeDataJob.getId())).executeUpdate();
    }
}
