package com.mcd.restaurant.repository;


import com.mcd.restaurant.model.Products;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@Component
public class ProductRepository extends JpaEntityRepositoryBase<Products, Integer> {
    public ProductRepository() {
        super(Products.class);
    }

    public ResourceList<Products> getProductByName(String productName) {
        QuerySpec querySpec = new QuerySpec(Products.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of("name"), FilterOperator.EQ, productName);
        querySpec.setFilters(Stream.of(filterSpec).collect(Collectors.toList()));
        return this.findAll(querySpec);
    }

}