package com.mcd.restaurant.repository;


import com.mcd.restaurant.model.PrePostDeploymentModel;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class PrePostDeploymentRepository extends JpaEntityRepositoryBase<PrePostDeploymentModel, Integer> {

    public PrePostDeploymentRepository() {
        super(PrePostDeploymentModel.class);
    }

    public List<PrePostDeploymentModel> getByDeploymentGroupIdAndStatus(Integer groupId, String status) {
        QuerySpec querySpec = new QuerySpec(PrePostDeploymentModel.class);
        FilterSpec filterGroupSpec = new FilterSpec(PathSpec.of("deploymentGroup.id"), FilterOperator.EQ, groupId);
        FilterSpec filterCheckStatus = new FilterSpec(PathSpec.of("status"), FilterOperator.EQ, status);
        FilterSpec filterFinalType = FilterSpec.and(Stream.of(filterGroupSpec, filterCheckStatus).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterFinalType).collect(Collectors.toList()));
        return this.findAll(querySpec);
    }


}
