package com.mcd.restaurant.repository;

import com.mcd.restaurant.model.BundleRelease;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class BundleReleaseRepository extends JpaEntityRepositoryBase<BundleRelease, Integer> {
    public BundleReleaseRepository() {
        super(BundleRelease.class);
    }

    public List<BundleRelease> findByReleaseName(String releaseName) {
        QuerySpec querySpec = new QuerySpec(BundleRelease.class);
        FilterSpec filterNameSpec = new FilterSpec(PathSpec.of("releaseName"), FilterOperator.EQ, releaseName);
        querySpec.setFilters(Stream.of(filterNameSpec).collect(Collectors.toList()));
        return this.findAll(querySpec);

    }
}
