package com.mcd.restaurant.reip.services;

import com.mcd.restaurant.model.ReipDeviceTypes;
import com.mcd.restaurant.model.ReipPropList;
import com.mcd.restaurant.reip.error.RestaurantEdgeIOTBadRequestException;
import com.mcd.restaurant.reip.view.request.DeviceAdapterOnboardingRequestDTO;
import com.mcd.restaurant.reip.view.request.DeviceRequestDTO;
import com.mcd.restaurant.reip.view.request.VendorOnboardingRequestDTO;
import com.mcd.restaurant.repository.ReipDeviceTypesRepository;
import com.mcd.restaurant.repository.ReipPropListRepository;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class RestaurantEdgeIOTValidator {
    @Autowired
    private ReipDeviceTypesRepository reipDeviceTypesRepository;
    private ReipPropListRepository reipPropListRepository;

    public void deviceAdapterOnboardingRequestDTOValidator(DeviceAdapterOnboardingRequestDTO requestDTO) {
        if (requestDTO.getStoreId() == null) {
            throw new RestaurantEdgeIOTBadRequestException("Store ID is required");
        }
        if (requestDTO.getDevices() == null) {
            throw new RestaurantEdgeIOTBadRequestException("Device is required");
        }
        requestDTO.getDevices().forEach(device -> {
            if (device.getDeviceTypeId() == null) {
                throw new RestaurantEdgeIOTBadRequestException("Device Type ID is required");
            }
            if (StringUtils.isBlank(device.getStatus())) {
                throw new RestaurantEdgeIOTBadRequestException("Status is required");
            }
            if (StringUtils.isBlank(device.getName())) {
                throw new RestaurantEdgeIOTBadRequestException("Name is required");
            }
            if (StringUtils.isBlank(device.getCreatedBy())) {
                throw new RestaurantEdgeIOTBadRequestException("CreatedBy is required");
            }
            ReipDeviceTypes deviceType = reipDeviceTypesRepository.findOne(device.getDeviceTypeId(), new QuerySpec(ReipDeviceTypes.class));
            validateIfNotAnAdapter(device, deviceType);
        });
    }

    public void vendorOnboardingRequestDTOValidator(VendorOnboardingRequestDTO requestDTO) {
        if (requestDTO.getVendorName() == null) {
            throw new RestaurantEdgeIOTBadRequestException("Vendor Name is required");
        }
        if (requestDTO.getDeviceTypes() == null) {
            throw new RestaurantEdgeIOTBadRequestException("Device is required");
        }
        if (StringUtils.isBlank(requestDTO.getCreatedBy())) {
            throw new RestaurantEdgeIOTBadRequestException("CreatedBy is required");
        }
        requestDTO.getDeviceTypes().forEach(device -> {
            if (device.getDeviceType() == null) {
                throw new RestaurantEdgeIOTBadRequestException("Device Type is required");
            }
            if (StringUtils.isBlank(device.getCategory())) {
                throw new RestaurantEdgeIOTBadRequestException("Category is required");
            }
        });
    }

    private void validateIfNotAnAdapter(DeviceRequestDTO device, ReipDeviceTypes deviceType) {
        if (!deviceType.getIsAdapter()) {
            if (device.getAdapterId() == null) {
                throw new RestaurantEdgeIOTBadRequestException("Adapter ID is required as device is not an adapter");
            }
            // Ignoring connector validation as some devices (MQTT enabled) do not need connector info
            //if (device.getConnectorId() == null) {
            //    throw new RestaurantEdgeIOTBadRequestException("Connector ID is required as device is not an adapter");
            //}
        }
    }
}
