package com.mcd.restaurant.reip.controller;

import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.reip.services.RestaurantEdgeIOTService;
import com.mcd.restaurant.reip.view.request.DeviceAdapterOnboardingRequestDTO;
import com.mcd.restaurant.reip.view.request.VendorOnboardingRequestDTO;
import com.mcd.restaurant.reip.view.response.DeviceAdapterOnboardingResponseDTO;
import com.mcd.restaurant.reip.view.response.VendorOnboardingResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(path = "/reip")
public class RestaurantEdgeIOTController {

    @Autowired
    private RestaurantEdgeIOTService restaurantEdgeIOTService;

    @PostMapping(path = "/onboard/device")
    public ResponseEntity<ResponseView<List<DeviceAdapterOnboardingResponseDTO>>> postDevice(
            @RequestBody DeviceAdapterOnboardingRequestDTO requestDTO) {
        ResponseView<List<DeviceAdapterOnboardingResponseDTO>> responseView = new ResponseView<>();
        responseView.setData(restaurantEdgeIOTService.onboardDevices(requestDTO));
        return ResponseEntity.status(HttpStatus.CREATED).body(responseView);
    }
    @PostMapping(path = "/onboard/vendor")
    public ResponseEntity<ResponseView<List<VendorOnboardingResponseDTO>>> postVendor(
            @RequestBody VendorOnboardingRequestDTO requestDTO) {
        ResponseView<List<VendorOnboardingResponseDTO>> responseView = new ResponseView<>();
        responseView.setData(restaurantEdgeIOTService.onboardVendors(requestDTO));
        return ResponseEntity.status(HttpStatus.CREATED).body(responseView);
    }
}
