package com.mcd.restaurant.productversions.controller;

import com.mcd.restaurant.common.ErrorCode;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.productversions.error.ProductDeploymentBadRequestException;
import com.mcd.restaurant.productversions.error.ProductDeploymentException;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ProductDeploymentControllerAdvice extends ResponseEntityExceptionHandler {

    @Autowired
    private ApiLoggingService apiLoggingService;

    @ExceptionHandler(ProductDeploymentBadRequestException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleBadRequest(ProductDeploymentBadRequestException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.PRODUCT_DEPLOYMENT_BAD_REQUEST_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }



    @ExceptionHandler(ProductDeploymentException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleGenericException(ProductDeploymentException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.PRODUCT_DEPLOYMENT_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.INTERNAL_SERVER_ERROR.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(responseView);
    }

}
