package com.mcd.restaurant.productversions.controller;

import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.productversions.controller.view.request.BulkProductDetailFetchRequestDTO;
import com.mcd.restaurant.productversions.controller.view.request.CreateProductRequestDTO;
import com.mcd.restaurant.productversions.controller.view.request.UpdateProductRequestDTO;
import com.mcd.restaurant.productversions.controller.view.request.UpdateProductVersionRequestDTO;
import com.mcd.restaurant.productversions.controller.view.response.BulkProductDetailResponseDTO;
import com.mcd.restaurant.productversions.controller.view.response.DeleteVersionResponseDTO;
import com.mcd.restaurant.productversions.controller.view.response.ProductResponseDTO;
import com.mcd.restaurant.productversions.controller.view.response.ProductVersionResponseDTO;
import com.mcd.restaurant.productversions.service.ProductDeploymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(path = "/products")
public class ProductDeploymentController {

    @Autowired
    private ProductDeploymentService productDeploymentService;

    @PostMapping(path = "/records")
    public ResponseEntity<ResponseView<ProductResponseDTO>> postProductRecords(
            @RequestBody CreateProductRequestDTO productVersionRequestDTO) {
        ResponseView<ProductResponseDTO> responseView = new ResponseView<>();
        responseView.setData(productDeploymentService.saveAllProductApplication(productVersionRequestDTO));
        return ResponseEntity.status(HttpStatus.CREATED).body(responseView);
    }


    @PatchMapping(path = "/records")
    public ResponseEntity<ResponseView<ProductResponseDTO>> patchProductRecords(
            @RequestBody UpdateProductRequestDTO updateProductRequestDTO) {
        ResponseView<ProductResponseDTO> responseView = new ResponseView<>();
        responseView.setData(productDeploymentService.updateProducts(updateProductRequestDTO));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }

    @PatchMapping(path = "/versions")
    public ResponseEntity<ResponseView<ProductVersionResponseDTO>> patchProductVersions(
            @RequestBody UpdateProductVersionRequestDTO updateProductVersionRequestDTO) {
        ResponseView<ProductVersionResponseDTO> responseView = new ResponseView<>();
        responseView.setData(productDeploymentService.updateProductVersions(updateProductVersionRequestDTO));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }

    @DeleteMapping(path = "/versions")
    public ResponseEntity<ResponseView<DeleteVersionResponseDTO>> deleteProductVersions(
            @RequestParam(name = "productVersionId") Integer productVersionId, @RequestParam(name = "productId") Integer productId) {
        ResponseView<DeleteVersionResponseDTO> responseView = new ResponseView<>();
        responseView.setData(productDeploymentService.deleteProductVersions(productVersionId, productId));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }


    @PostMapping(path = "/version/details")
    public ResponseEntity<ResponseView<BulkProductDetailResponseDTO>> fetchBulkProductDetail(
            @RequestBody BulkProductDetailFetchRequestDTO requestDTO) {
        ResponseView<BulkProductDetailResponseDTO> responseView = new ResponseView<>();
        responseView.setData(productDeploymentService.fetchBulkProductDetails(requestDTO));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }


}
