package com.mcd.restaurant.model;


import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;


@Entity
@Data
@Table(name="vendor_type", indexes={@Index(name="vendor_type_id_IX", columnList="id", unique=true)})
@NoArgsConstructor
@JsonApiResource(type = "vendor_type")
public class VendorType implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(unique=true, nullable=false)
    private String name;
    
    @Column
    private String description;
    
    @CreationTimestamp
    private Timestamp created;
    
    @UpdateTimestamp
    private Timestamp updated;
}