package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import javax.persistence.*;
import java.io.Serializable;


@Entity
@Data
@Table(name="vendor_contacts", indexes={@Index(name="vendor_contacts_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "vendor_contacts")
public class VendorContacts implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JoinColumn(name="contact_id", nullable=false)
    @JsonIgnoreProperties("contacts")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Contacts contacts;

    @ManyToOne
    @JoinColumn(name="vendor_id", nullable=false)
    @JsonIgnoreProperties("vendors")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Vendor vendors;

    @Column(name="level")
    private String level;

    @Lob
    @Column(name="notes", length=1024)
    private String notes;
}