package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Entity
@Data
@Table(name="reip_device_type_props", indexes={@Index(name="reip_device_type_props_id_IX", columnList="id", unique=true)})
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_device_type_props")
public class ReipDeviceTypeProps implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable=false)
    private String name;

    @Column(name = "is_connector")
    private Boolean isConnector;

    @ManyToOne
    @JoinColumn(name="device_type_id", nullable=false)
    @JsonIgnoreProperties("reipDeviceTypeProps")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceTypes reipDeviceTypes;

    @OneToMany(mappedBy="reipDeviceTypeProps")
    @JsonApiRelation(mappedBy = "reipDeviceTypeProps")
    @ToString.Exclude
    @JsonIgnoreProperties("reipDeviceTypeProps")
    private List<ReipDeviceAdapterMapping> reipDeviceAdapterMapping;
}