package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "reip_device_instances", indexes = {@Index(name = "reip_device_instances_id_IX", columnList = "id", unique = true)})
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_device_instances")
public class ReipDeviceInstances implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false, unique = true)
    private String name;

    @Column(name = "serial_number")
    private String serialNumber;

    @Column(name = "model_number")
    private String modelNumber;
    //can be null
    @Column(name = "firmware_version")
    private String firmwareVersion;

    @ManyToOne
    @JoinColumn(name = "restaurant_id", nullable = false)
    @JsonIgnoreProperties("reipDeviceInstances")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Restaurant restaurant;

    @Column(name = "status", nullable = false)
    private String status;

    @Column(name = "created_by", nullable = false)
    private String createdBy;

    @Column(name = "created_by_contact")
    private String createdByContact;

    @Column(name = "offboarded_by")
    private String offBoardedBy;

    @Column(name = "offboarded_by_contact")
    private String offBoardedByContact;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @ManyToOne
    @JoinColumn(name = "device_type_id", nullable = false)
    @JsonIgnoreProperties("reipDeviceInstances")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceTypes reipDeviceTypes;

    @OneToMany(mappedBy = "reipDeviceInstances")
    @JsonIgnoreProperties("reipDeviceInstances")
    @JsonApiRelation(mappedBy = "reipDeviceInstances")
    @ToString.Exclude
    private List<ReipDeviceInstanceAuditHistory> reipDeviceInstanceAuditHistory;

    @OneToMany(mappedBy = "reipDeviceInstances")
    @JsonApiRelation(mappedBy = "reipDeviceInstances")
    @JsonIgnoreProperties("reipDeviceInstances")
    @ToString.Exclude
    private List<ReipDeviceInstanceProps> reipDeviceInstanceProps;

    @OneToMany(mappedBy = "reipAdapterInstance")
    @JsonApiRelation(mappedBy = "reipAdapterInstance")
    @ToString.Exclude
    @JsonIgnoreProperties("reipAdapterInstance")
    private List<ReipDeviceAdapterMapping> reipAdapterInstanceMapping;

    @OneToMany(mappedBy = "reipDeviceInstance")
    @JsonApiRelation(mappedBy = "reipDeviceInstance")
    @JsonIgnoreProperties("reipDeviceInstance")
    @ToString.Exclude
    private List<ReipDeviceAdapterMapping> reipDeviceInstanceMapping;

    @OneToOne(mappedBy = "reipDeviceInstance")
    @JsonApiRelation(mappedBy = "reipDeviceInstance")
    @JsonIgnoreProperties("reipDeviceInstance")
    @ToString.Exclude
    private ReipBlacklistDevice reipBlacklistDevice;
}