package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.sql.Timestamp;

@Entity
@Data
@Builder
@Table(name = "pre_post_deployment", indexes = {
        @Index(name = "pre_post_deployment_IX", columnList = "id", unique = true)})
@AllArgsConstructor
@NoArgsConstructor
@JsonApiResource(type = "pre_post_deployment")
public class PrePostDeploymentModel {

    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column
    private String initiatedBy;

    @Column
    private String type;

    @Column
    private String status;

    @Column
    private String reportPath;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @ManyToOne
    @JoinColumn(name = "deployment_group_id", nullable = false)
    @JsonIgnoreProperties("prePostDeployment")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private DeploymentGroup deploymentGroup;
}
