package com.mcd.restaurant.model;


import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiResource;
import org.hibernate.annotations.CreationTimestamp;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="pxuuid_mapping", indexes={@Index(name="pxuuid_mapping_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "pxuuid_mapping")
public class PXUUIDMapping implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name="restaurant_name")
    private String restaurant_name;

    @Column(name="environment")
    private String environment;

    @Lob
    @Column(name="uuid")
    private String uuid;

    @CreationTimestamp
    private Timestamp created;
}