package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "owner_operators", indexes = {@Index(name = "owner_operators_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "owner_operators")
public class OwnerOperator implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String name;

    @Column(name = "contact_info_type")
    private String contactInfoType;

    @Column(name = "contact_info")
    private String contactInfo;

    @Column(name = "bre_subscription")
    private String breSubscription;

    @Column(name = "onsite_support_engineer")
    private String onsiteSupportEngineer;

    @Column
    private String preferences;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "ownerOperator")
    @JsonIgnoreProperties("ownerOperator")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private List<Restaurant> restaurants;
}
