package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name = "menu_hierarchy_nodes", indexes = {@Index(name = "menu_hierarchy_nodes_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "hierarchy_nodes")
public class HierarchyNode implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JoinColumn(name = "menu_hierarchy_level_id", insertable = false, updatable = false)
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @JsonIgnoreProperties("hierarchyNodes")
    @ToString.Exclude
    private HierarchyLevel hierarchyLevel;

    @Column(name = "menu_hierarchy_level_id")
    private String hierarchyLevelId;

    @Column(name = "mcd_restaurant_id")
    private Integer mcdRestaurantId;

    @Column(name = "mcd_internal_node_id")
    private Integer mcdInternalNodeId;

    @Column(name = "mcd_internal_node_name")
    private String mcdInternalNodeName;

    @Column(name = "parent_hierarchy_level_id")
    private Integer parentHierarchyLevelId;

    @Column(name = "parent_node_id")
    private Integer parentNodeId;

    @Column(name = "is_active")
    private String isActive;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;
}
