package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name = "component_audit_history", indexes = {@Index(name = "component_audit_history_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "component_audit_history")
public class ComponentAuditHistory implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JsonIgnoreProperties("componentAuditHistory")
    @JoinColumn(name = "component_id", nullable = false)
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Component component;

    @Column(name = "action", nullable = false)
    private String action;

    @Column(name = "src_of_action", nullable = false)
    private String srcOfAction;

    @CreationTimestamp
    private Timestamp created;

    @CreationTimestamp
    private Timestamp updated;

    @Lob
    @Column(name = "description", length = 1024)
    private String description;
}
