package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "bundle_release", indexes = {@Index(name = "bundle_release_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "bundle_release")
public class BundleRelease implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name = "release_name", nullable = false)
    private String releaseName;

    @ManyToOne
    @JoinColumn(name = "template_id")
    @JsonIgnoreProperties("template")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Template template;

    @Column(name = "status", nullable = false)
    private String status;

    @Column(name = "type")
    private String type;

    @Column(name = "created_by", nullable = false)
    private String createdBy;

    @Column(name = "updated_by", nullable = false)
    private String updatedBy;

    @Column(name = "release_date")
    private Timestamp releaseDate;
    @Column(name = "git_tag")
    private String gitTag;
    @Column(name = "remarks")
    private String remarks;
    @Column(name = "commit_id")
    private String commitId;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "bundleRelease")
    @JsonIgnoreProperties("bundleRelease")
    @JsonApiRelation(mappedBy = "bundleRelease")
    @ToString.Exclude
    private List<BundleReleaseAppVersion> bundleReleaseAppVersions;

    @OneToMany(mappedBy = "bundleRelease")
    @JsonIgnoreProperties("bundleRelease")
    @JsonApiRelation(mappedBy = "bundleRelease")
    @ToString.Exclude
    private List<DeploymentGroup> deploymentGroups;
}