package com.mcd.restaurant.model;

import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;


@Entity
@Data
@Table(name = "bre_hierarchy_nodes", indexes = {@Index(name = "bre_hierarchy_nodes_IX", columnList = "id", unique = true)})
@Builder
@AllArgsConstructor
@NoArgsConstructor
@JsonApiResource(type = "bre_hierarchy_nodes")
public class BreHierarchyNode implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name = "nodeName")
    private String nodeName;

    @Column(name = "restaurant_no")
    private String restaurantNo;


    @Column(name = "ip_address")
    private String ipAddress;

    @Column(name = "hierarchy_level",nullable = false)
    private Integer hierarchyLevel;

    @Column(name = "parent_market_id")
    private Integer marketNodeId;

    @Column(name = "parent_region_id")
    private Integer regionNodeId;

    @Column(name = "parent_coop_id")
    private Integer coopNodeId;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

}
