package com.mcd.restaurant.filter;

import com.mcd.restaurant.service.ApiLoggingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class UnauthorizedHandler implements AuthenticationEntryPoint {

    @Autowired
    private ApiLoggingService apiLoggingService;

    @Override
    public void commence(HttpServletRequest req, HttpServletResponse res,
                         AuthenticationException authenticationException) throws IOException {
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(req);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(res);
        res.sendError(HttpStatus.FORBIDDEN.value(), "Access Denied");
        apiLoggingService.logHttp(requestWrapper, responseWrapper);
    }
}