package com.mcd.restaurant.deployment.controller.view.response;

import com.mcd.restaurant.model.PrePostDeploymentModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeploymentCheckResponseDTO {
    private int id;
    private String initiatedBy;
    private String type;
    private String reportPath;
    private String status;
    private Integer deploymentGroupId;

    public static DeploymentCheckResponseDTO build(PrePostDeploymentModel model) {
        return DeploymentCheckResponseDTO.builder()
                .id(model.getId())
                .deploymentGroupId(model.getDeploymentGroup().getId())
                .initiatedBy(model.getInitiatedBy())
                .reportPath(model.getReportPath())
                .type(model.getType()).status(model.getStatus())
                .build();
    }
}
