package com.mcd.restaurant.dashboard.controller;


import com.mcd.restaurant.common.ErrorCode;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.dashboard.error.StoreDashboardBadRequestException;
import com.mcd.restaurant.dashboard.error.StoreDashboardException;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/**
 * ControllerAdvice responsible for handling error for store-dashboard module
 */
@ControllerAdvice
public class StoreDashboardControllerAdvice extends ResponseEntityExceptionHandler {


    @Autowired
    private ApiLoggingService apiLoggingService;

    @ExceptionHandler(StoreDashboardException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handlesStoredashboardException(StoreDashboardException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.STORE_DASHBOARD_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.INTERNAL_SERVER_ERROR.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(responseView);
    }

    @ExceptionHandler(StoreDashboardBadRequestException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handlesStoredashboardBadRequestException(StoreDashboardBadRequestException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.STORE_DASHBOARD_BAD_REQUEST_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }

}
