package com.mcd.restaurant.configuration;

import com.mcd.restaurant.filter.UnauthorizedHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.header.writers.StaticHeadersWriter;

@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {
    @Value("${allow.origin:*}")
    private String allowOrigin;

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable().headers().addHeaderWriter(new StaticHeadersWriter("Access-Control-Allow-Origin", allowOrigin)).and().authorizeRequests()
                .antMatchers(HttpMethod.OPTIONS).permitAll()
                .antMatchers(HttpMethod.GET).permitAll()
                .antMatchers(HttpMethod.POST).permitAll()
                .antMatchers(HttpMethod.PUT).permitAll()
                .antMatchers(HttpMethod.PATCH).permitAll()
                .antMatchers(HttpMethod.DELETE, "/restaurant_assets/components/**").permitAll()
                .antMatchers(HttpMethod.DELETE, "/restaurant_assets/vendor_contacts/**").permitAll()
                .antMatchers(HttpMethod.DELETE, "/restaurant_assets/deployment_groups/**").permitAll()
                .antMatchers(HttpMethod.DELETE, "/deployment/archival/**").permitAll()
                .antMatchers(HttpMethod.DELETE, "/bundledRelease/version/**").permitAll()
                .antMatchers(HttpMethod.DELETE, "/products/**").permitAll()
                .antMatchers(HttpMethod.DELETE).denyAll()
                .and().exceptionHandling().authenticationEntryPoint(authenticationEntryPoint());

    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new UnauthorizedHandler();
    }
}
