package com.mcd.restaurant.component.controller;

import com.mcd.restaurant.common.ErrorCode;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.component.error.ComponentBadRequestException;
import com.mcd.restaurant.component.error.ComponentError;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ComponentControllerAdvice extends ResponseEntityExceptionHandler {

    @Autowired
    private ApiLoggingService apiLoggingService;

    @ExceptionHandler(ComponentBadRequestException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleInvalidComponent(ComponentBadRequestException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.COMPONENT_BAD_REQUEST_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }

    @ExceptionHandler(ComponentError.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleComponentError(ComponentError ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.COMPONENT_ERROR)
                .setStatus(Integer.toString(HttpStatus.INTERNAL_SERVER_ERROR.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(responseView);
    }

}
