package com.mcd.restaurant.bundledrelease.controller.view.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mcd.restaurant.bundledrelease.controller.view.request.BundledAppVersionRequest;
import lombok.Data;

@Data
public class BundledReleaseAppVersionResponse {

    @JsonProperty("appId")
    private Integer appId;
    @JsonProperty("appVersionId")
    private Integer bundleReleaseId;
    @JsonProperty("version")
    private String version;
    @JsonProperty("path")
    private String path;
    @JsonProperty("productVersionId")
    private Integer productVersionId;

    public static BundledReleaseAppVersionResponse build(BundledAppVersionRequest request, Integer id) {
        BundledReleaseAppVersionResponse response = new BundledReleaseAppVersionResponse();
        response.bundleReleaseId = id;
        response.appId = request.getAppId();
        response.version = request.getAppVersion();
        response.path = request.getArtifactoryPath();
        response.productVersionId = request.getProductVersionId();
        return response;
    }

}
