package com.mcd.restaurant.bundledrelease.controller;

import com.mcd.restaurant.bundledrelease.controller.view.request.BundledReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleDeploymentDetailsRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundleReleaseGenericResponse;
import com.mcd.restaurant.bundledrelease.service.BundledReleaseService;
import com.mcd.restaurant.bundledrelease.validator.BundleReleaseValidator;
import com.mcd.restaurant.common.ResponseView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * Controller responsible for creating bundled Releases and saving all relationships data together.
 */
@RestController
@RequestMapping(path = "/bundledRelease")
public class BundledReleaseController {

    @Autowired
    BundledReleaseService bundledReleaseService;
    @Autowired
    private BundleReleaseValidator bundleReleaseValidator;

    /**
     * This methods creates the Bundle Release and its corresponding application entries in BundleRelease and BundleReleaseAppVersion Table
     */
    @PostMapping(path = "/versions")
    public ResponseEntity<ResponseView<BundleReleaseGenericResponse>> postBundleRelease(
            @RequestBody BundledReleaseRequest bundledReleaseRequest) {
        ResponseView<BundleReleaseGenericResponse> responseView = new ResponseView<>();
        bundleReleaseValidator.validateBundleReleaseRequest(bundledReleaseRequest);
        responseView.setData(bundledReleaseService.saveBundleRelease(bundledReleaseRequest));
        return ResponseEntity.status(HttpStatus.CREATED).body(responseView);
    }

    /**
     * This methods updates the existing Bundle's application details
     */
    @PatchMapping(path = "/versions")
    public ResponseEntity<ResponseView<BundleReleaseGenericResponse>> editBundleRelease(
            @RequestBody UpdateBundleReleaseRequest updateBundleReleaseRequest) {
        ResponseView<BundleReleaseGenericResponse> responseView = new ResponseView<>();
        bundleReleaseValidator.validateUpdateBundleReleaseRequest(updateBundleReleaseRequest);
        responseView.setData(bundledReleaseService.editBundleRelease(updateBundleReleaseRequest));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }

    /**
     * This method deletes the bundle from the database
     */
    @DeleteMapping("/version/{releaseId}")
    public ResponseEntity<ResponseView<BundleReleaseGenericResponse>> deleteBundleRelease(
            @PathVariable(value = "releaseId") Integer releaseId) {
        ResponseView<BundleReleaseGenericResponse> responseView = new ResponseView<>();
        responseView.setData(bundledReleaseService.deleteBundleRelease(releaseId));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }

    /**
     * This methods updates the existing Bundle's application details
     */
    @PatchMapping(path = "/deployment/details")
    public ResponseEntity<ResponseView<BundleReleaseGenericResponse>> updateDeploymentDetails(
            @RequestBody UpdateBundleDeploymentDetailsRequest deploymentDetailsRequest) {
        ResponseView<BundleReleaseGenericResponse> responseView = new ResponseView<>();
        bundleReleaseValidator.validateUpdateBundleDeploymentDetailsRequest(deploymentDetailsRequest);
        responseView.setData(bundledReleaseService.editDeploymentDetailForBundle(deploymentDetailsRequest));
        return ResponseEntity.status(HttpStatus.OK).body(responseView);
    }


}
