package com.mcd.restaurant.reip;

import com.mcd.restaurant.reip.error.RestaurantEdgeIOTBadRequestException;
import com.mcd.restaurant.reip.error.RestaurantEdgeIOTException;
import com.mcd.restaurant.reip.services.RestaurantEdgeIOTService;
import com.mcd.restaurant.reip.services.RestaurantEdgeIOTValidator;
import com.mcd.restaurant.reip.view.request.DeviceAdapterOnboardingRequestDTO;
import com.mcd.restaurant.reip.view.request.DeviceRequestDTO;
import com.mcd.restaurant.reip.view.request.DeviceTypeRequestDTO;
import com.mcd.restaurant.reip.view.request.VendorOnboardingRequestDTO;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertThrows;

class RestaurantEdgeIOTServiceTest {
    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @InjectMocks
    private RestaurantEdgeIOTService edgeIOTService;
    @InjectMocks
    private RestaurantEdgeIOTValidator restaurantEdgeIOTValidator;
    @Mock
    private RestaurantEdgeIOTValidator restaurantEdgeIOTValidatorMock;

    @Test
    void onboardDevicesBadRequestStoreId() {
        ReflectionTestUtils.setField(edgeIOTService,"restaurantEdgeIOTValidator",restaurantEdgeIOTValidator);
        DeviceAdapterOnboardingRequestDTO requestDTO = new DeviceAdapterOnboardingRequestDTO();
        assertThrows(RestaurantEdgeIOTBadRequestException.class, () -> edgeIOTService.onboardDevices(requestDTO));
    }

    @Test
    void onboardDevicesBadRequestDeviceDetail() {
        ReflectionTestUtils.setField(edgeIOTService,"restaurantEdgeIOTValidator",restaurantEdgeIOTValidator);
        DeviceAdapterOnboardingRequestDTO requestDTO = new DeviceAdapterOnboardingRequestDTO();
        requestDTO.setStoreId(1);
        DeviceRequestDTO device=new DeviceRequestDTO();
        requestDTO.setDevices(Stream.of(device).collect(Collectors.toList()));
        assertThrows(RestaurantEdgeIOTBadRequestException.class, () -> edgeIOTService.onboardDevices(requestDTO));
    }

    @Test
    void onboardDevicesgenericException() {
        Mockito.doThrow(new NullPointerException("Generic Exception")).when(restaurantEdgeIOTValidatorMock).deviceAdapterOnboardingRequestDTOValidator(Mockito.any(DeviceAdapterOnboardingRequestDTO.class));
        DeviceAdapterOnboardingRequestDTO requestDTO = new DeviceAdapterOnboardingRequestDTO();
        requestDTO.setStoreId(1);
        DeviceRequestDTO device=new DeviceRequestDTO();
        requestDTO.setDevices(Stream.of(device).collect(Collectors.toList()));
        assertThrows(RestaurantEdgeIOTException.class, () -> edgeIOTService.onboardDevices(requestDTO));
    }

    @Test
    void onboardVendorsBadRequestDeviceDetail() {
        ReflectionTestUtils.setField(edgeIOTService,"restaurantEdgeIOTValidator",restaurantEdgeIOTValidator);
        VendorOnboardingRequestDTO requestDTO = new VendorOnboardingRequestDTO();
        requestDTO.setVendorName(null);
        DeviceTypeRequestDTO deviceType=new DeviceTypeRequestDTO();
        requestDTO.setDeviceTypes(Stream.of(deviceType).collect(Collectors.toList()));
        assertThrows(RestaurantEdgeIOTBadRequestException.class, () -> edgeIOTService.onboardVendors(requestDTO));
    }

    @Test
    void onboardVendorsgenericException() {
        Mockito.doThrow(new NullPointerException("Generic Exception")).when(restaurantEdgeIOTValidatorMock).vendorOnboardingRequestDTOValidator(Mockito.any(VendorOnboardingRequestDTO.class));
        VendorOnboardingRequestDTO requestDTO = new VendorOnboardingRequestDTO();
        requestDTO.setVendorName(null);
        DeviceTypeRequestDTO deviceType=new DeviceTypeRequestDTO();
        requestDTO.setDeviceTypes(Stream.of(deviceType).collect(Collectors.toList()));
        assertThrows(RestaurantEdgeIOTException.class, () -> edgeIOTService.onboardVendors(requestDTO));
    }

}
