package com.mcd.restaurant.productVersions;

import com.mcd.restaurant.productversions.controller.ProductDeploymentController;
import com.mcd.restaurant.productversions.controller.view.request.UpdateProductVersionRequestDTO;
import com.mcd.restaurant.productversions.controller.view.response.ProductVersionResponseDTO;
import com.mcd.restaurant.productversions.service.ProductDeploymentService;
import com.mcd.restaurant.repository.ProductApplicationRepository;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.CoreMatchers.*;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class ProductDeploymentControllerTest {

    private RequestSpecification spec;

    @Mock
    private ProductApplicationRepository productApplicationRepository;
    @Mock
    private ProductDeploymentService productDeploymentService;
    @InjectMocks
    private ProductDeploymentController productDeploymentController;

    @LocalServerPort
    int port;


    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void postDeploymentRecordSuccess() {
        String jsonBody = "{\n" +
                "\n" +
                "    \"productName\":\"Product-New-10/7/2022\",\n" +
                "    \"applications\":[\n" +
                "        {\n" +
                "            \"applicationName\":\"bred-helloworld\",\n" +
                "            \"applicationVersion\":\"90\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"applicationName\":\"aidt-trservice\",\n" +
                "            \"applicationVersion\":\"1.9.0\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        }\n" +
                "\n" +
                "    ]\n" +
                "\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/products/records")
                .then().assertThat().statusCode(is(201))
                .body("data.productVersions", notNullValue())
                .body("data.name", notNullValue())
                .body("data.id", equalTo(2));
    }

    @Test
    void patchProductRecordsSuccess() {
        String jsonBody = "{\n" +
                "\n" +
                "    \"productId\":\"1\",\n" +
                "    \"versionName\":\"12.2.2\",\n" +
                "    \"applications\":[\n" +
                "        {\n" +
                "            \"applicationName\":\"bred-helloworld\",\n" +
                "            \"applicationVersion\":\"90\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"applicationName\":\"aidt-trservice\",\n" +
                "            \"applicationVersion\":\"1.9.0\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        }\n" +
                "\n" +
                "    ]\n" +
                "\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .patch("/products/records")
                .then().assertThat().statusCode(is(200))
                .body("data.productVersions", notNullValue())
                .body("data.name", notNullValue())
                .body("data.id", equalTo(1));
    }

    @Test
    void patchProductRecordsNameSuccess() {
        String jsonBody = "{\n" +
                "\n" +
                "    \"productName\":\"Product-123\",\n" +
                "    \"versionName\":\"12.2.22\",\n" +
                "    \"applications\":[\n" +
                "        {\n" +
                "            \"applicationName\":\"bred-helloworld\",\n" +
                "            \"applicationVersion\":\"90\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"applicationName\":\"aidt-trservice\",\n" +
                "            \"applicationVersion\":\"1.9.0\",\n" +
                "            \"applicationURL\":\"URL\",\n" +
                "            \"type\":\"docker\"\n" +
                "        }\n" +
                "\n" +
                "    ]\n" +
                "\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .patch("/products/records")
                .then().assertThat().statusCode(is(200))
                .body("data.productVersions", notNullValue())
                .body("data.name", notNullValue())
                .body("data.id", equalTo(1));
    }

    @Test
    void patchProductRecordsNameDoesNotExist() {
        String jsonBody = "{\n" +
                "\n" +
                "    \"productName\":\"Prod_Invalid\",\n" +
                "    \"versionName\":\"12.2.22\",\n" +
                "    \"applications\":[\n" +
                "        {\n" +
                "            \"applicationName\":\"bred-helloworld\",\n" +
                "            \"applicationVersion\":\"90\",\n" +
                "            \"type\":\"docker\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"applicationName\":\"aidt-trservice\",\n" +
                "            \"applicationVersion\":\"1.9.0\",\n" +
                "            \"type\":\"docker\"\n" +
                "        }\n" +
                "\n" +
                "    ]\n" +
                "\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .patch("/products/records")
                .then().assertThat().statusCode(is(400));
    }


    @Test
    void deleteProductVersionsSuccess() {
        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .when()
                .delete("/products/versions?productVersionId=1&productId=1")
                .then().assertThat().statusCode(is(200));
    }

    @Test
    void testPatchProductVersions() {
        Mockito.when(productDeploymentService.updateProductVersions(Mockito.any())).thenReturn(new ProductVersionResponseDTO());
        Assertions.assertNotNull(productDeploymentController.patchProductVersions(new UpdateProductVersionRequestDTO()));
    }

    @Test
    void getFetchBulkProductDetail() {
        String json = "{\n" +
                "    \"productVersion\":[\n" +
                "    {\n" +
                "        \"productName\":\"Product-123\",\n" +
                "        \"versionName\":\"2.0.0\"\n" +
                "    }]\n" +
                "}";
        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(json)
                .when()
                .post("/products/version/details")
                .then().assertThat().statusCode(is(200));
    }

    @Test
    void getFetchBulkProductDetailBadRequesT() {
        String json1 = "{\n" +
                "    \"productVersion\":[\n" +
                "    {\n" +
                "        \"versionName\":\"2.0.0\"\n" +
                "    }]\n" +
                "}";
        String json2 = "{\n" +
                "    \"productVersion\":[\n" +
                "    {\n" +
                "        \"productName\":\"Product-123\"\n" +
                "    }]\n" +
                "}";
        String json3 = "{}";
        for (String json:
             Stream.of(json1, json2, json3).collect(Collectors.toList())) {
            RestAssured.given(this.spec)
                    .accept("application/json")
                    .contentType("application/json")
                    .body(json)
                    .when()
                    .post("/products/version/details")
                    .then().assertThat().statusCode(is(400));
        }
    }


}
