package com.mcd.restaurant.dashboard.testUtils;

import com.mcd.restaurant.dashboard.enums.HierarchyLevel;
import com.mcd.restaurant.model.BreHierarchyNode;
import com.mcd.restaurant.model.Market;
import com.mcd.restaurant.model.Restaurant;
import com.mcd.restaurant.model.StoreDemographic;
import com.opencsv.CSVWriter;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.restassured.internal.util.IOUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
public class StoreDashboardTestUtils {

    public MultipartFile getMultipartValidFileForIpAddress() throws IOException {
        File storeNetwork = new File("store-network.csv");
        FileWriter outputfile = new FileWriter(storeNetwork);
        CSVWriter writer = new CSVWriter(outputfile);
        List<String[]> data = new ArrayList<>();
        data.add(new String[]{"National Store #", "Service-Network Segment"});
        data.add(new String[]{"1", "1:12:13:14"});
        writer.writeAll(data);
        writer.close();
        storeNetwork.deleteOnExit();
        return new MockMultipartFile("storenetwork",
                storeNetwork.getName(), "text/csv", IOUtils.toByteArray(new FileInputStream(storeNetwork)));

    }

    public MultipartFile getMultipartValidFileForHierarchyStructure() throws IOException {
        File hierarchyStructure = new File("hierarchy-structure.csv");
        FileWriter outputfile = new FileWriter(hierarchyStructure);
        CSVWriter writer = new CSVWriter(outputfile);
        List<String[]> data = new ArrayList<>();
        data.add(new String[]{"Node Type", "Restaurant Number", "Node Name", "Parent Node Name", "Priority"});
        data.add(new String[]{"Market", "", "US Country Office", "US Country Office", "1"});
        data.add(new String[]{"Region", "", "Atlanta Region", "US Country Office", "2"});
        data.add(new String[]{"Coop", "", "01 - WWOA", "Atlanta Region", "2"});
        data.add(new String[]{"Coop", "", "01 - WWOABC", "India Region", "2"});
        data.add(new String[]{"Store", "14285", "104TH AND REDWOOD", "01 - WWOA", "2"});
        data.add(new String[]{"Store", "14285", "104TH AND REDWOOD", "01 - WWOABC", "2"});
        writer.writeAll(data);
        writer.close();
        hierarchyStructure.deleteOnExit();
        return new MockMultipartFile("hierrachyStructure",
                hierarchyStructure.getName(), "text/csv", IOUtils.toByteArray(new FileInputStream(hierarchyStructure)));

    }

    public MultipartFile getMultipartValidFileForDemoGraphicStructure() throws IOException {
        File demographicStructure = new File("demographic-structure.csv");
        FileWriter outputfile = new FileWriter(demographicStructure);
        CSVWriter writer = new CSVWriter(outputfile);
        List<String[]> data = new ArrayList<>();
        data.add(new String[]{"NODE TYPE", "NODE NAME", "RESTAURANT NUMBER", "ADDRESS", "CITY", "STATE", "COUNTRY", "ZIP", "PHONE", "OWNER NAME", "OWNER TYPE", "LATITUDE", "LONGITUDE"});
        data.add(new String[]{"Market", "US Country Office", "", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Region", "Atlanta Region", "", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Coop", "", "01 - WWOA", "", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Coop", "", "01 - WWOABC", "India Region", "2"});
        data.add(new String[]{"Store", "104TH AND REDWOOD", "12233", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Store", "104TH AND REDWOOD", "12234", "", "", "", "", "", "", "", "", "", ""});
        writer.writeAll(data);
        writer.close();
        demographicStructure.deleteOnExit();
        return new MockMultipartFile("demographicStructure",
                demographicStructure.getName(), "text/csv", IOUtils.toByteArray(new FileInputStream(demographicStructure)));

    }

    public MultipartFile getInvalidMultipartValidFileForDemoGraphicStructure() throws IOException {
        File demographicFile = new File("demographic-structure.csv");
        FileWriter outputfile = new FileWriter(demographicFile);
        CSVWriter writer = new CSVWriter(outputfile);
        List<String[]> data = new ArrayList<>();
        data.add(new String[]{"NODE TYPE", "NODE NAME", "RESTAURANT NUMBER", "ADDRESS", "CITY", "STATE", "COUNTRY", "ZIP", "PHONE", "OWNER NAME", "OWNER TYPE", "LATITUDE", "LONGITUDE"});
        data.add(new String[]{"Region", "Atlanta Region", "", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Coop", "", "01 - WWOA", "", "", "", "", "", "", "", "", "", "", ""});
        data.add(new String[]{"Coop", "", "01 - WWOABC", "India Region", "2"});
        data.add(new String[]{"Store", "104TH AND REDWOOD", "12233", "", "", "", "", "", "", "", "", "", ""});
        writer.writeAll(data);
        writer.close();
        demographicFile.deleteOnExit();
        return new MockMultipartFile("demographicStructure",
                demographicFile.getName(), "text/csv", IOUtils.toByteArray(new FileInputStream(demographicFile)));

    }

    public BreHierarchyNode getMarketNode() {
        BreHierarchyNode breHierarchyNode = new BreHierarchyNode();
        breHierarchyNode.setHierarchyLevel(HierarchyLevel.MARKET.value());
        breHierarchyNode.setNodeName("US Country Office");
        breHierarchyNode.setId(1);
        return breHierarchyNode;
    }

    public BreHierarchyNode getStoreNode() {
        BreHierarchyNode storeNode = new BreHierarchyNode();
        storeNode.setHierarchyLevel(HierarchyLevel.RESTAURANT.value());
        storeNode.setNodeName("104TH AND REDWOOD");
        storeNode.setRestaurantNo("12234");
        storeNode.setCreated(Timestamp.valueOf(LocalDateTime.now()));
        storeNode.setId(3);
        return storeNode;
    }

    public StoreDemographic getDemographicNode() {
        StoreDemographic demographic = new StoreDemographic();
        demographic.setCreated(Timestamp.valueOf(LocalDateTime.now()));
        demographic.setHierarchyNode(getStoreNode());
        return demographic;
    }

    public ResourceList<Restaurant> getRestaurantList() {
        ResourceList<Restaurant> restaurants = new DefaultResourceList<>();
        Restaurant restaurant = new Restaurant();
        restaurant.setName("12234");
        restaurant.setId(1);
        restaurants.add(restaurant);
        return restaurants;
    }

    public ResourceList<BreHierarchyNode> getBreHierarchyNodesList() {
        BreHierarchyNode node1 = BreHierarchyNode.builder().id(1).restaurantNo("12234").build();
        ResourceList<BreHierarchyNode> list = new DefaultResourceList<>();
        list.add(node1);
        return list;
    }


    public ResourceList<Market> getMarkets() {
        Market market = new Market();
        market.setId(1);
        market.setName("US");
        ResourceList<Market> list = new DefaultResourceList<>();
        list.add(market);
        return list;
    }
}
