package com.mcd.restaurant.component;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class ComponentControllerTest {

    private RequestSpecification spec;

    @LocalServerPort
    int port;


    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

//    @Test
//    void insertDeviceDataSuccess() {
//        String jsonBody = "{\n" +
//                "    \"deviceDetail\": [\n" +
//                "        {\n" +
//                "            \"marketName\": \"US\",\n" +
//                "            \"restaurantName\": \"101\",\n" +
//                "            \"modelNumber\": \"41\",\n" +
//                "            \"reportedVersion\": \"6.50.5.1\",\n" +
//                "            \"serialNumber\": \"123345634\",\n" +
//                "            \"hardwareVersion\": \"2\",\n" +
//                "            \"deviceName\": \"99124-Axix-123\",\n" +
//                "            \"deviceProps\": [\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"laneNumber\",\n" +
//                "                    \"propertyValue\": \"1\"\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"macAddress\",\n" +
//                "                    \"propertyValue\": \"AC:CC:8E:F7:8B:F2\"\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"ipAddress\",\n" +
//                "                    \"propertyValue\": \"123.32.12.36\"\n" +
//                "                }\n" +
//                "            ]\n" +
//                "        }\n" +
//                "    ]\n" +
//                "}";
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .contentType("application/json")
//                .body(jsonBody)
//                .when()
//                .post("/component/device")
//                .then().assertThat().statusCode(is(201));
//    }
//
//    @Test
//    void updateDeviceDataSuccess() {
//        String jsonBody = "{\n" +
//                "    \"deviceDetail\": [\n" +
//                "        {\n" +
//                "            \"marketName\": \"US\",\n" +
//                "            \"restaurantName\": \"101\",\n" +
//                "            \"modelNumber\": \"41\",\n" +
//                "            \"reportedVersion\": \"6.50.5.1\",\n" +
//                "            \"serialNumber\": \"ACCC8EF78BE2\",\n" +
//                "            \"hardwareVersion\": \"2\",\n" +
//                "            \"deviceProps\": [\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"laneNumber\",\n" +
//                "                    \"propertyValue\": \"1\"\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"macAddress\",\n" +
//                "                    \"propertyValue\": \"AC:CC:8E:F7:8B:F2\"\n" +
//                "                },\n" +
//                "                {\n" +
//                "                    \"propertyName\": \"ipAddress\",\n" +
//                "                    \"propertyValue\": \"123.32.12.36\"\n" +
//                "                }\n" +
//                "            ]\n" +
//                "        }\n" +
//                "    ]\n" +
//                "}";
//        RestAssured.given(this.spec)
//                .accept("application/json")
//                .contentType("application/json")
//                .body(jsonBody)
//                .when()
//                .post("/component/device")
//                .then().assertThat().statusCode(is(201));
//    }

    @Test
    void insertDeviceDataFailure() {
        String jsonBody = "{\n" +
                "    \"deviceDetail\": [\n" +
                "        {\n" +
                "            \"marketName\": \"US\",\n" +
                "            \"restaurantName\": \"101\",\n" +
                "            \"modelNumber\": \"41\",\n" +
                "            \"reportedVersion\": \"6.50.5.1\",\n" +
                "            \"serialNumber\": ,\n" +
                "            \"hardwareVersion\": \"2\",\n" +
                "            \"deviceProps\": [\n" +
                "                {\n" +
                "                    \"propertyName\": \"laneNumber\",\n" +
                "                    \"propertyValue\": \"1\"\n" +
                "                },\n" +
                "                {\n" +
                "                    \"propertyName\": \"macAddress\",\n" +
                "                    \"propertyValue\": \"AC:CC:8E:F7:8B:F2\"\n" +
                "                },\n" +
                "                {\n" +
                "                    \"propertyName\": \"ipAddress\",\n" +
                "                    \"propertyValue\": \"123.32.12.36\"\n" +
                "                }\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/component/device")
                .then().assertThat().statusCode(is(400));
    }

}
