package com.mcd.restaurant.bundleRelease.testUtils;

import com.mcd.restaurant.bundledrelease.controller.view.request.BundledAppVersionRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.BundledReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleAppVersionRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundleReleaseGenericResponse;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundledReleaseResponse;
import com.mcd.restaurant.model.BundleReleaseAppVersion;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class BundleReleaseTestUtility {

    public BundledReleaseRequest prepareBundleReleaseRequestWithAppVersionListMissing() {
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setReleaseName("R-1");
        bundledReleaseRequest.setCreatedBy("xyz");
        bundledReleaseRequest.setBundledAppVersionRequestList(new ArrayList<BundledAppVersionRequest>());
        return bundledReleaseRequest;

    }

    public BundledReleaseRequest prepareBundleReleaseRequestWithReleaseNameMissing() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setCreatedBy("xyz");
        bundledReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return bundledReleaseRequest;
    }

    public BundledReleaseRequest prepareBundleReleaseRequestSuccess() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setReleaseName("R-1");
        bundledReleaseRequest.setCreatedBy("xyz");
        bundledReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return bundledReleaseRequest;
    }


    public BundledReleaseRequest prepareBundleReleaseRequestWithTemplateIdMissing() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setCreatedBy("xyz");
        bundledReleaseRequest.setReleaseName("R-1");
        bundledReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return bundledReleaseRequest;
    }

    public BundledReleaseRequest prepareBundleReleaseRequestWithCreatedByMissing() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setReleaseName("R-1");
        bundledReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return bundledReleaseRequest;
    }

    public List<BundledAppVersionRequest> getAppVersionRequests() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = new ArrayList<>();
        BundledAppVersionRequest bundledAppVersionRequest = new BundledAppVersionRequest();
        bundledAppVersionRequest.setAppVersion("def");
        bundledAppVersionRequest.setArtifactoryPath("test_path");
        bundledAppVersionRequestList.add(bundledAppVersionRequest);
        return bundledAppVersionRequestList;
    }

    public BundleReleaseGenericResponse prepareSuccessResponse() {
        BundledReleaseResponse bundledReleaseResponse = new BundledReleaseResponse();
        bundledReleaseResponse.setReleaseId(1);
        bundledReleaseResponse.setReleaseName("R-1");
        bundledReleaseResponse.setTotalApps(3);
        bundledReleaseResponse.setIsSuccess(true);
        return bundledReleaseResponse;
    }


    public UpdateBundleReleaseRequest prepareUpdateBundleReleaseRequestWithReleaseIdMissing() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        UpdateBundleReleaseRequest updateBundleReleaseRequest = new UpdateBundleReleaseRequest();
        updateBundleReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return updateBundleReleaseRequest;
    }

    public UpdateBundleReleaseRequest prepareUpdateBundleReleaseRequestSuccess() {
        List<BundledAppVersionRequest> bundledAppVersionRequestList = getAppVersionRequests();
        UpdateBundleReleaseRequest updateBundleReleaseRequest = new UpdateBundleReleaseRequest();
        updateBundleReleaseRequest.setReleaseId(1);
        updateBundleReleaseRequest.setUpdatedBy("ABC");
        updateBundleReleaseRequest.setBundledAppVersionRequestList(bundledAppVersionRequestList);
        return updateBundleReleaseRequest;
    }

    public UpdateBundleReleaseRequest prepareUpdateBundleReleaseRequestWithAppsMissing() {
        UpdateBundleReleaseRequest updateBundleReleaseRequest = new UpdateBundleReleaseRequest();
        updateBundleReleaseRequest.setReleaseId(1);
        updateBundleReleaseRequest.setBundledAppVersionRequestList(new ArrayList<>());
        return updateBundleReleaseRequest;
    }

    public List<UpdateBundleAppVersionRequest> getUpdateAppVersionRequests() {
        List<UpdateBundleAppVersionRequest> bundledAppVersionRequestList = new ArrayList<>();
        UpdateBundleAppVersionRequest updateBundleAppVersionRequest = new UpdateBundleAppVersionRequest();
        updateBundleAppVersionRequest.setReleaseAppVersionId(1);
        updateBundleAppVersionRequest.setAppVersion("def");
        updateBundleAppVersionRequest.setArtifactoryPath("test_path");
        bundledAppVersionRequestList.add(updateBundleAppVersionRequest);
        return bundledAppVersionRequestList;
    }

    public BundleReleaseGenericResponse prepareSuccessResponseForEdit() {
        BundledReleaseResponse bundledReleaseResponse = new BundledReleaseResponse();
        bundledReleaseResponse.setTotalApps(3);
        bundledReleaseResponse.setIsSuccess(true);
        return bundledReleaseResponse;
    }

    public ResourceList<BundleReleaseAppVersion> getBundleAppReleaseList() {
        ResourceList<BundleReleaseAppVersion> appVersionList = new DefaultResourceList<>();
        BundleReleaseAppVersion appVersion = new BundleReleaseAppVersion();
        appVersion.setId(1);
        appVersionList.add(appVersion);
        return appVersionList;

    }
}
